/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.remote.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BoundedInputStream
extends FilterInputStream {
    private final int limit;
    private int count;

    public BoundedInputStream(InputStream in, int limit) {
        super(in);
        this.limit = limit;
    }

    @Override
    public int read() throws IOException {
        if (this.count < this.limit) {
            int c = this.in.read();
            if (c != -1) {
                ++this.count;
            }
            return c;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.count < this.limit) {
            int n;
            if (this.limit - this.count < len) {
                len = this.limit - this.count;
            }
            if ((n = this.in.read(b, off, len)) > 0) {
                this.count += n;
            }
            return n;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        try {
            int remains = this.limit - this.count;
            if (remains > 0) {
                this.in.skip(remains);
            }
        }
        finally {
            this.in = null;
        }
    }
}

