/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.server;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ServerSocketFactory;
import org.apache.jackrabbit.mk.api.MicroKernel;
import org.apache.jackrabbit.mk.server.FileServlet;
import org.apache.jackrabbit.mk.server.HttpProcessor;
import org.apache.jackrabbit.mk.server.MicroKernelServlet;
import org.apache.jackrabbit.mk.server.Request;
import org.apache.jackrabbit.mk.server.Response;
import org.apache.jackrabbit.mk.server.Servlet;

public class Server {
    private static final int BACKLOG = 50;
    private final ServerSocketFactory ssFactory;
    private AtomicReference<MicroKernel> mkref;
    private AtomicBoolean started = new AtomicBoolean();
    private AtomicBoolean stopped = new AtomicBoolean();
    private ServerSocket ss;
    private ExecutorService es;
    private int port;
    private InetAddress addr;

    public Server(MicroKernel mk) {
        this(mk, ServerSocketFactory.getDefault());
        this.mkref = new AtomicReference<MicroKernel>(mk);
    }

    public Server(MicroKernel mk, ServerSocketFactory ssFactory) {
        this.mkref = new AtomicReference<MicroKernel>(mk);
        this.ssFactory = ssFactory;
    }

    public void setPort(int port) throws IllegalStateException {
        if (this.started.get()) {
            throw new IllegalStateException("Server already started.");
        }
        this.port = port;
    }

    public void setBindAddress(InetAddress addr) throws IllegalStateException {
        if (this.started.get()) {
            throw new IllegalStateException("Server already started.");
        }
        this.addr = addr;
    }

    public void start() throws IOException {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        this.ss = this.createServerSocket();
        this.es = this.createExecutorService();
        new Thread(new Runnable(){

            @Override
            public void run() {
                Server.this.accept();
            }
        }, "Acceptor").start();
    }

    void accept() {
        try {
            while (!this.stopped.get()) {
                final Socket socket = this.ss.accept();
                this.es.execute(new Runnable(){

                    @Override
                    public void run() {
                        Server.this.process(socket);
                    }
                });
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private ServerSocket createServerSocket() throws IOException {
        return this.ssFactory.createServerSocket(this.port, 50, this.addr);
    }

    private ExecutorService createExecutorService() {
        return Executors.newCachedThreadPool();
    }

    void process(Socket socket) {
        try {
            socket.setTcpNoDelay(true);
        }
        catch (IOException e) {
            // empty catch block
        }
        HttpProcessor processor = new HttpProcessor(socket, new Servlet(){

            @Override
            public void service(Request request, Response response) throws IOException {
                Server.this.service(request, response);
            }
        });
        try {
            processor.process();
        }
        catch (SocketTimeoutException e) {
        }
        catch (EOFException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void service(Request request, Response response) throws IOException {
        if (request.getMethod().equals("POST")) {
            MicroKernelServlet.INSTANCE.service(this.mkref.get(), request, response);
        } else {
            FileServlet.INSTANCE.service(request, response);
        }
    }

    public InetSocketAddress getAddress() {
        if (!this.started.get() || this.stopped.get()) {
            return null;
        }
        SocketAddress address = this.ss.getLocalSocketAddress();
        if (address instanceof InetSocketAddress) {
            InetSocketAddress isa = (InetSocketAddress)address;
            if (isa.getAddress().isAnyLocalAddress()) {
                try {
                    return new InetSocketAddress(InetAddress.getByName("localhost"), this.ss.getLocalPort());
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException(e);
                }
            }
            return isa;
        }
        return null;
    }

    public void stop() {
        if (!this.stopped.compareAndSet(false, true)) {
            return;
        }
        if (this.es != null) {
            this.es.shutdown();
        }
        if (this.ss != null) {
            try {
                this.ss.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

