/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.server;

import java.io.IOException;
import java.io.InputStream;

class BoundaryInputStream
extends InputStream {
    private InputStream in;
    private final byte[] boundary;
    private final byte[] buf;
    private int offset;
    private int count;
    private int boundaryIndex;
    private boolean eos;

    public BoundaryInputStream(InputStream in, String boundary) {
        this(in, boundary, 8192);
    }

    public BoundaryInputStream(InputStream in, String boundary, int size) {
        this.in = in;
        this.boundary = ("\r\n" + boundary).getBytes();
        if (size < this.boundary.length + 2) {
            size = this.boundary.length + 2;
        }
        this.buf = new byte[size];
    }

    @Override
    public int read() throws IOException {
        if (this.eos) {
            return -1;
        }
        byte[] b = new byte[1];
        int count = this.read(b, 0, 1);
        if (count == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.eos) {
            return -1;
        }
        if (this.offset == this.count) {
            this.fillBuffer();
            if (this.eos) {
                return -1;
            }
        }
        return this.copy(b, off, len);
    }

    private void fillBuffer() throws IOException {
        if (this.boundaryIndex > 0) {
            System.arraycopy(this.boundary, 0, this.buf, 0, this.boundaryIndex);
        }
        this.offset = this.boundaryIndex;
        this.count = this.in.read(this.buf, this.offset, this.buf.length - this.offset);
        if (this.count < 0) {
            this.eos = true;
        }
        this.count += this.offset;
    }

    private int copy(byte[] b, int off, int len) throws IOException {
        int i = 0;
        int j = 0;
        while (this.offset + i < this.count && j < len) {
            if (this.boundary[this.boundaryIndex] == this.buf[this.offset + i]) {
                ++this.boundaryIndex;
                ++i;
                if (this.boundaryIndex != this.boundary.length) continue;
                this.eos = true;
                break;
            }
            if (this.boundaryIndex > 0) {
                if ((i -= this.boundaryIndex) < 0) {
                    this.offset += i;
                    i = 0;
                }
                this.boundaryIndex = 0;
            }
            b[off + j] = this.buf[this.offset + i];
            ++i;
            ++j;
        }
        this.offset += i;
        return j == 0 && this.eos ? -1 : j;
    }

    @Override
    public void close() throws IOException {
        this.in = null;
        this.eos = true;
    }
}

