/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.server;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.jackrabbit.mk.server.Request;
import org.apache.jackrabbit.mk.server.Response;
import org.apache.jackrabbit.mk.server.Servlet;
import org.apache.jackrabbit.oak.commons.IOUtils;

class FileServlet
implements Servlet {
    public static FileServlet INSTANCE = new FileServlet();
    private static final HashMap<String, String> MIME_TYPES = new HashMap();

    private FileServlet() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void service(Request request, Response response) throws IOException {
        InputStream in;
        String file = request.getFile();
        if (file.endsWith("/")) {
            file = file + "index.html";
        }
        if ((in = FileServlet.class.getResourceAsStream(file.substring(1))) != null) {
            try {
                int dotIndex = file.lastIndexOf(46);
                if (dotIndex != -1) {
                    String contentType = MIME_TYPES.get(file.substring(dotIndex + 1));
                    if (contentType == null) {
                        contentType = "application/octet-stream";
                    }
                    response.setContentType(contentType);
                }
                IOUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
            }
            finally {
                IOUtils.closeQuietly((Closeable)in);
            }
        } else {
            response.setStatusCode(404);
        }
    }

    static {
        MIME_TYPES.put("html", "text/html");
        MIME_TYPES.put("css", "text/css");
        MIME_TYPES.put("js", "application/javascript");
        MIME_TYPES.put("json", "application/json");
        MIME_TYPES.put("png", "image/png");
    }
}

