/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.util;

import java.util.ArrayList;
import org.apache.jackrabbit.mk.json.JsopTokenizer;
import org.apache.jackrabbit.mk.util.NameFilter;

public class NodeFilter {
    private final NameFilter nodeFilter;
    private final NameFilter propFilter;

    private NodeFilter(NameFilter nodeFilter, NameFilter propFilter) {
        this.nodeFilter = nodeFilter;
        this.propFilter = propFilter;
    }

    public static NodeFilter parse(String json) {
        JsopTokenizer t = new JsopTokenizer(json);
        t.read(123);
        NameFilter nodeFilter = null;
        NameFilter propFilter = null;
        do {
            String type = t.readString();
            t.read(58);
            String[] globs = NodeFilter.parseArray(t);
            if (type.equals("nodes")) {
                nodeFilter = new NameFilter(globs);
                continue;
            }
            if (type.equals("properties")) {
                propFilter = new NameFilter(globs);
                continue;
            }
            throw new IllegalArgumentException("illegal filter format");
        } while (t.matches(44));
        t.read(125);
        return new NodeFilter(nodeFilter, propFilter);
    }

    private static String[] parseArray(JsopTokenizer t) {
        ArrayList<String> l = new ArrayList<String>();
        t.read(91);
        do {
            l.add(t.readString());
        } while (t.matches(44));
        t.read(93);
        return l.toArray(new String[l.size()]);
    }

    public NameFilter getChildNodeFilter() {
        return this.nodeFilter;
    }

    public NameFilter getPropertyFilter() {
        return this.propFilter;
    }

    public boolean includeNode(String name) {
        return this.nodeFilter == null || this.nodeFilter.matches(name);
    }

    public boolean includeProperty(String name) {
        return this.propFilter == null || this.propFilter.matches(name);
    }
}

