/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.mk.model.ChildNodeEntry;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.NodeDiffHandler;
import org.apache.jackrabbit.mk.model.StoredNode;

public class NodeDelta
implements NodeDiffHandler {
    private final StoredNode node1;
    private final StoredNode node2;
    Map<String, String> addedProperties = new HashMap<String, String>();
    Map<String, String> removedProperties = new HashMap<String, String>();
    Map<String, String> changedProperties = new HashMap<String, String>();
    Map<String, Id> addedChildNodes = new HashMap<String, Id>();
    Map<String, Id> removedChildNodes = new HashMap<String, Id>();
    Map<String, Id> changedChildNodes = new HashMap<String, Id>();

    public NodeDelta(StoredNode node1, StoredNode node2) {
        this.node1 = node1;
        this.node2 = node2;
        node1.diff(node2, this);
    }

    public Map<String, String> getAddedProperties() {
        return this.addedProperties;
    }

    public Map<String, String> getRemovedProperties() {
        return this.removedProperties;
    }

    public Map<String, String> getChangedProperties() {
        return this.changedProperties;
    }

    public Map<String, Id> getAddedChildNodes() {
        return this.addedChildNodes;
    }

    public Map<String, Id> getRemovedChildNodes() {
        return this.removedChildNodes;
    }

    public Map<String, Id> getChangedChildNodes() {
        return this.changedChildNodes;
    }

    public boolean conflictsWith(NodeDelta other) {
        return !this.listConflicts(other).isEmpty();
    }

    public List<Conflict> listConflicts(NodeDelta other) {
        if (!this.node1.getId().equals(other.node1.getId())) {
            throw new IllegalArgumentException("other and this NodeDelta object are expected to share common node1 instance");
        }
        ArrayList<Conflict> conflicts = new ArrayList<Conflict>();
        Map<String, String> otherAddedProps = other.getAddedProperties();
        for (Map.Entry<String, String> added : this.addedProperties.entrySet()) {
            String otherValue = otherAddedProps.get(added.getKey());
            if (otherValue == null || added.getValue().equals(otherValue)) continue;
            conflicts.add(new Conflict(ConflictType.PROPERTY_VALUE_CONFLICT, added.getKey()));
        }
        Map<String, String> otherChangedProps = other.getChangedProperties();
        Map<String, String> otherRemovedProps = other.getRemovedProperties();
        for (Map.Entry<String, String> changed : this.changedProperties.entrySet()) {
            String otherValue = otherChangedProps.get(changed.getKey());
            if (otherValue != null && !changed.getValue().equals(otherValue)) {
                conflicts.add(new Conflict(ConflictType.PROPERTY_VALUE_CONFLICT, changed.getKey()));
            }
            if (!otherRemovedProps.containsKey(changed.getKey())) continue;
            conflicts.add(new Conflict(ConflictType.REMOVED_DIRTY_PROPERTY_CONFLICT, changed.getKey()));
        }
        for (Map.Entry<String, String> removed : this.removedProperties.entrySet()) {
            if (!otherChangedProps.containsKey(removed.getKey())) continue;
            conflicts.add(new Conflict(ConflictType.REMOVED_DIRTY_PROPERTY_CONFLICT, removed.getKey()));
        }
        Map<String, Id> otherAddedChildNodes = other.getAddedChildNodes();
        for (Map.Entry<String, Id> added : this.addedChildNodes.entrySet()) {
            Id otherValue = otherAddedChildNodes.get(added.getKey());
            if (otherValue == null || added.getValue().equals(otherValue)) continue;
            conflicts.add(new Conflict(ConflictType.NODE_CONTENT_CONFLICT, added.getKey()));
        }
        Map<String, Id> otherChangedChildNodes = other.getChangedChildNodes();
        Map<String, Id> otherRemovedChildNodes = other.getRemovedChildNodes();
        for (Map.Entry<String, Id> changed : this.changedChildNodes.entrySet()) {
            Id otherValue = otherChangedChildNodes.get(changed.getKey());
            if (otherValue != null && !changed.getValue().equals(otherValue)) {
                conflicts.add(new Conflict(ConflictType.NODE_CONTENT_CONFLICT, changed.getKey()));
            }
            if (!otherRemovedChildNodes.containsKey(changed.getKey())) continue;
            conflicts.add(new Conflict(ConflictType.REMOVED_DIRTY_NODE_CONFLICT, changed.getKey()));
        }
        for (Map.Entry<String, Id> removed : this.removedChildNodes.entrySet()) {
            if (!otherChangedChildNodes.containsKey(removed.getKey())) continue;
            conflicts.add(new Conflict(ConflictType.REMOVED_DIRTY_NODE_CONFLICT, removed.getKey()));
        }
        return conflicts;
    }

    @Override
    public void propAdded(String propName, String value) {
        this.addedProperties.put(propName, value);
    }

    @Override
    public void propChanged(String propName, String oldValue, String newValue) {
        this.changedProperties.put(propName, newValue);
    }

    @Override
    public void propDeleted(String propName, String value) {
        this.removedProperties.put(propName, value);
    }

    @Override
    public void childNodeAdded(ChildNodeEntry added) {
        this.addedChildNodes.put(added.getName(), added.getId());
    }

    @Override
    public void childNodeDeleted(ChildNodeEntry deleted) {
        this.removedChildNodes.put(deleted.getName(), deleted.getId());
    }

    @Override
    public void childNodeChanged(ChildNodeEntry changed, Id newId) {
        this.changedChildNodes.put(changed.getName(), newId);
    }

    public static class Conflict {
        final ConflictType type;
        final String name;

        Conflict(ConflictType type, String name) {
            this.type = type;
            this.name = name;
        }

        public ConflictType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum ConflictType {
        PROPERTY_VALUE_CONFLICT,
        NODE_CONTENT_CONFLICT,
        REMOVED_DIRTY_PROPERTY_CONFLICT,
        REMOVED_DIRTY_NODE_CONFLICT;

    }
}

