/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.query;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

public interface QueryIndex {
    public double getMinimumCost();

    public double getCost(Filter var1, NodeState var2);

    public Cursor query(Filter var1, NodeState var2);

    public String getPlan(Filter var1, NodeState var2);

    public String getIndexName();

    public static interface NodeAggregator {
        public Iterator<String> getParents(NodeState var1, String var2);
    }

    public static class OrderEntry {
        private final String propertyName;
        private final Type<?> propertyType;
        private final Order order;

        public OrderEntry(String propertyName, Type<?> propertyType, Order order) {
            this.propertyName = propertyName;
            this.propertyType = propertyType;
            this.order = order;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public Order getOrder() {
            return this.order;
        }

        public Type<?> getPropertyType() {
            return this.propertyType;
        }

        public String toString() {
            return String.format("{ propertyName : %s, propertyType : %s, order : %s }", new Object[]{this.propertyName, this.propertyType, this.order});
        }

        public static enum Order {
            ASCENDING,
            DESCENDING;

        }
    }

    @ProviderType
    public static interface IndexPlan
    extends Cloneable {
        public double getCostPerExecution();

        public double getCostPerEntry();

        public long getEstimatedEntryCount();

        public Filter getFilter();

        public void setFilter(Filter var1);

        public boolean isDelayed();

        public boolean isFulltextIndex();

        public boolean includesNodeData();

        public List<OrderEntry> getSortOrder();

        public NodeState getDefinition();

        public String getPathPrefix();

        public boolean getSupportsPathRestriction();

        @Nullable
        public Filter.PropertyRestriction getPropertyRestriction();

        public IndexPlan copy();

        @Nullable
        public Object getAttribute(String var1);

        @Nullable
        public String getPlanName();

        public boolean isDeprecated();

        public static class Builder {
            protected double costPerExecution = 1.0;
            protected double costPerEntry = 1.0;
            protected long estimatedEntryCount = 1000000L;
            protected Filter filter;
            protected boolean isDelayed;
            protected boolean isFulltextIndex;
            protected boolean includesNodeData;
            protected List<OrderEntry> sortOrder;
            protected NodeState definition;
            protected Filter.PropertyRestriction propRestriction;
            protected String pathPrefix = "/";
            protected boolean supportsPathRestriction = false;
            protected Map<String, Object> attributes = Maps.newHashMap();
            protected String planName;
            protected boolean deprecated;

            public Builder setCostPerExecution(double costPerExecution) {
                this.costPerExecution = costPerExecution;
                return this;
            }

            public Builder setCostPerEntry(double costPerEntry) {
                this.costPerEntry = costPerEntry;
                return this;
            }

            public Builder setEstimatedEntryCount(long estimatedEntryCount) {
                this.estimatedEntryCount = estimatedEntryCount;
                return this;
            }

            public Builder setFilter(Filter filter) {
                this.filter = filter;
                return this;
            }

            public Builder setDelayed(boolean isDelayed) {
                this.isDelayed = isDelayed;
                return this;
            }

            public Builder setFulltextIndex(boolean isFulltextIndex) {
                this.isFulltextIndex = isFulltextIndex;
                return this;
            }

            public Builder setIncludesNodeData(boolean includesNodeData) {
                this.includesNodeData = includesNodeData;
                return this;
            }

            public Builder setSortOrder(List<OrderEntry> sortOrder) {
                this.sortOrder = sortOrder;
                return this;
            }

            public Builder setDefinition(NodeState definition) {
                this.definition = definition;
                return this;
            }

            public Builder setPropertyRestriction(Filter.PropertyRestriction restriction) {
                this.propRestriction = restriction;
                return this;
            }

            public Builder setPathPrefix(String pathPrefix) {
                this.pathPrefix = pathPrefix;
                return this;
            }

            public Builder setSupportsPathRestriction(boolean supportsPathRestriction) {
                this.supportsPathRestriction = supportsPathRestriction;
                return this;
            }

            public Builder setAttribute(String key, Object value) {
                this.attributes.put(key, value);
                return this;
            }

            public Builder setPlanName(String name) {
                this.planName = name;
                return this;
            }

            public Builder setDeprecated(boolean deprecated) {
                this.deprecated = deprecated;
                return this;
            }

            public IndexPlan build() {
                return new IndexPlan(){
                    private final double costPerExecution;
                    private final double costPerEntry;
                    private final long estimatedEntryCount;
                    private Filter filter;
                    private final boolean isDelayed;
                    private final boolean isFulltextIndex;
                    private final boolean includesNodeData;
                    private final List<OrderEntry> sortOrder;
                    private final NodeState definition;
                    private final Filter.PropertyRestriction propRestriction;
                    private final String pathPrefix;
                    private final boolean supportsPathRestriction;
                    private final Map<String, Object> attributes;
                    private final String planName;
                    private final boolean deprecated;
                    {
                        this.costPerExecution = costPerExecution;
                        this.costPerEntry = costPerEntry;
                        this.estimatedEntryCount = estimatedEntryCount;
                        this.filter = filter;
                        this.isDelayed = isDelayed;
                        this.isFulltextIndex = isFulltextIndex;
                        this.includesNodeData = includesNodeData;
                        this.sortOrder = sortOrder == null ? null : new ArrayList<OrderEntry>(sortOrder);
                        this.definition = definition;
                        this.propRestriction = propRestriction;
                        this.pathPrefix = pathPrefix;
                        this.supportsPathRestriction = supportsPathRestriction;
                        this.attributes = attributes;
                        this.planName = planName;
                        this.deprecated = deprecated;
                    }

                    public String toString() {
                        return String.format("{ costPerExecution : %s, costPerEntry : %s, estimatedEntryCount : %s, filter : %s, isDelayed : %s, isFulltextIndex : %s, includesNodeData : %s, sortOrder : %s, definition : %s, propertyRestriction : %s, pathPrefix : %s, deprecated : %s, supportsPathRestriction : %s }", this.costPerExecution, this.costPerEntry, this.estimatedEntryCount, this.filter, this.isDelayed, this.isFulltextIndex, this.includesNodeData, this.sortOrder, this.definition, this.propRestriction, this.pathPrefix, this.deprecated, this.supportsPathRestriction);
                    }

                    @Override
                    public double getCostPerExecution() {
                        return this.costPerExecution;
                    }

                    @Override
                    public double getCostPerEntry() {
                        return this.costPerEntry;
                    }

                    @Override
                    public long getEstimatedEntryCount() {
                        return this.estimatedEntryCount;
                    }

                    @Override
                    public Filter getFilter() {
                        return this.filter;
                    }

                    @Override
                    public void setFilter(Filter filter) {
                        this.filter = filter;
                    }

                    @Override
                    public boolean isDelayed() {
                        return this.isDelayed;
                    }

                    @Override
                    public boolean isFulltextIndex() {
                        return this.isFulltextIndex;
                    }

                    @Override
                    public boolean includesNodeData() {
                        return this.includesNodeData;
                    }

                    @Override
                    public List<OrderEntry> getSortOrder() {
                        return this.sortOrder;
                    }

                    @Override
                    public NodeState getDefinition() {
                        return this.definition;
                    }

                    @Override
                    public Filter.PropertyRestriction getPropertyRestriction() {
                        return this.propRestriction;
                    }

                    @Override
                    public String getPathPrefix() {
                        return this.pathPrefix;
                    }

                    @Override
                    public boolean getSupportsPathRestriction() {
                        return this.supportsPathRestriction;
                    }

                    protected Object clone() throws CloneNotSupportedException {
                        return super.clone();
                    }

                    @Override
                    public IndexPlan copy() {
                        try {
                            return (IndexPlan)super.clone();
                        }
                        catch (CloneNotSupportedException e) {
                            throw new IllegalStateException(e);
                        }
                    }

                    @Override
                    public Object getAttribute(String name) {
                        return this.attributes.get(name);
                    }

                    @Override
                    public String getPlanName() {
                        return this.planName;
                    }

                    @Override
                    public boolean isDeprecated() {
                        return this.deprecated;
                    }
                };
            }
        }
    }

    public static interface AdvancedQueryIndex {
        public List<IndexPlan> getPlans(Filter var1, List<OrderEntry> var2, NodeState var3);

        public String getPlanDescription(IndexPlan var1, NodeState var2);

        public Cursor query(IndexPlan var1, NodeState var2);
    }

    public static interface AdvanceFulltextQueryIndex
    extends FulltextQueryIndex,
    AdvancedQueryIndex {
    }

    public static interface FulltextQueryIndex
    extends QueryIndex,
    NativeQueryIndex {
        @Nullable
        public NodeAggregator getNodeAggregator();
    }

    public static interface NativeQueryIndex {
    }
}

