/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.fixture;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.felix.cm.file.ConfigurationHandler;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.FileDataStore;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.fixture.DataStoreUtils;
import org.apache.jackrabbit.oak.plugins.blob.BlobStoreStats;
import org.apache.jackrabbit.oak.plugins.blob.datastore.DataStoreBlobStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.FileBlobStore;
import org.apache.jackrabbit.oak.spi.blob.MemoryBlobStore;
import org.apache.jackrabbit.oak.spi.blob.stats.BlobStatsCollector;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.jetbrains.annotations.Nullable;

public abstract class BlobStoreFixture
implements Closeable {
    private final String name;
    protected final String unique;

    public BlobStoreFixture(String name) {
        this.name = name;
        this.unique = BlobStoreFixture.getUniqueName(name);
    }

    public abstract BlobStore setUp();

    public abstract void tearDown();

    public abstract long size();

    @Override
    public void close() {
        this.tearDown();
    }

    @Nullable
    public static BlobStoreFixture create(File basedir, boolean fallbackToFDS, int fdsCacheInMB, StatisticsProvider statisticsProvider) {
        String className;
        if (basedir == null) {
            basedir = FileUtils.getTempDirectory();
        }
        if ((className = System.getProperty("dataStore")) != null) {
            return BlobStoreFixture.getDataStore(basedir, fdsCacheInMB, statisticsProvider);
        }
        String blobStore = System.getProperty("blobStoreType");
        if ("FDS".equals(blobStore) || blobStore == null && fallbackToFDS) {
            return BlobStoreFixture.getFileDataStore(basedir, 16, statisticsProvider);
        }
        if ("FBS".equals(blobStore)) {
            return BlobStoreFixture.getFileBlobStore(basedir);
        }
        if ("MEM".equals(blobStore)) {
            return BlobStoreFixture.getMemoryBlobStore();
        }
        return null;
    }

    public static BlobStoreFixture getFileDataStore(final File basedir, final int fdsCacheInMB, final StatisticsProvider statisticsProvider) {
        return new BlobStoreFixture("FDS"){
            private File storeDir;
            private FileDataStore fds;

            @Override
            public BlobStore setUp() {
                this.fds = new FileDataStore();
                this.fds.setMinRecordLength(4092);
                this.storeDir = new File(basedir, this.unique);
                this.fds.init(this.storeDir.getAbsolutePath());
                BlobStoreFixture.configure(this.fds);
                DataStoreBlobStore bs = new DataStoreBlobStore((DataStore)this.fds, true, fdsCacheInMB);
                bs.setBlobStatsCollector((BlobStatsCollector)new BlobStoreStats(statisticsProvider));
                BlobStoreFixture.configure(bs);
                return bs;
            }

            @Override
            public void tearDown() {
                this.fds.close();
                FileUtils.deleteQuietly((File)this.storeDir);
            }

            @Override
            public long size() {
                return FileUtils.sizeOfDirectory((File)this.storeDir);
            }
        };
    }

    public static BlobStoreFixture getFileBlobStore(final File basedir) {
        return new BlobStoreFixture("FBS"){
            private File storeDir;
            private FileBlobStore fbs;

            @Override
            public BlobStore setUp() {
                this.storeDir = new File(basedir, this.unique);
                this.fbs = new FileBlobStore(this.storeDir.getAbsolutePath());
                BlobStoreFixture.configure(this.fbs);
                return this.fbs;
            }

            @Override
            public void tearDown() {
                FileUtils.deleteQuietly((File)this.storeDir);
            }

            @Override
            public long size() {
                return FileUtils.sizeOfDirectory((File)this.storeDir);
            }
        };
    }

    public static BlobStoreFixture getMemoryBlobStore() {
        return new BlobStoreFixture("MEM"){
            private MemoryBlobStore mbs = new MemoryBlobStore();

            @Override
            public BlobStore setUp() {
                return this.mbs;
            }

            @Override
            public void tearDown() {
            }

            @Override
            public long size() {
                throw new UnsupportedOperationException("Implementation pending");
            }
        };
    }

    public static BlobStoreFixture getDataStore(final File basedir, final int fdsCacheInMB, final StatisticsProvider statisticsProvider) {
        return new BlobStoreFixture("DS"){
            private DataStore dataStore;
            private BlobStore blobStore;
            private File storeDir;
            private Map<String, ?> config;

            @Override
            public BlobStore setUp() {
                String className = System.getProperty("dataStore");
                Preconditions.checkNotNull((Object)className, (Object)"No system property named 'dataStore' defined");
                try {
                    this.dataStore = Class.forName(className).asSubclass(DataStore.class).newInstance();
                    this.config = 4.getConfig();
                    BlobStoreFixture.configure(this.dataStore, this.config);
                    this.dataStore = DataStoreUtils.configureIfCloudDataStore(className, this.dataStore, this.config, this.unique.toLowerCase(), statisticsProvider);
                    this.storeDir = new File(basedir, this.unique);
                    this.dataStore.init(this.storeDir.getAbsolutePath());
                    this.blobStore = new DataStoreBlobStore(this.dataStore, true, fdsCacheInMB);
                    BlobStoreFixture.configure(this.blobStore);
                    return this.blobStore;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Cannot instantiate DataStore " + className, e);
                }
            }

            @Override
            public void tearDown() {
                if (this.blobStore instanceof DataStoreBlobStore) {
                    try {
                        ((DataStoreBlobStore)this.blobStore).close();
                        DataStoreUtils.cleanup(this.storeDir, this.config, this.unique.toLowerCase());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            @Override
            public long size() {
                throw new UnsupportedOperationException("Implementation pending");
            }
        };
    }

    private static String getUniqueName(String name) {
        return String.format("%s-%d", name, System.currentTimeMillis());
    }

    private static void configure(Object o) {
        PropertiesUtil.populate((Object)o, BlobStoreFixture.getConfig(), (boolean)false);
    }

    private static void configure(Object o, Map<String, ?> config) {
        PropertiesUtil.populate((Object)o, config, (boolean)false);
    }

    public static Map<String, Object> loadAndTransformProps(String cfgPath) throws IOException {
        Dictionary dict = ConfigurationHandler.read((InputStream)new FileInputStream(cfgPath));
        HashMap props = Maps.newHashMap();
        Enumeration keys = dict.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            props.put(key, dict.get(key));
        }
        return props;
    }

    public static Map<String, ?> getConfig() {
        String cfgFile = System.getProperty("ds.config");
        Map<Object, Object> result = Maps.newHashMap();
        if (!Strings.isNullOrEmpty((String)cfgFile)) {
            try {
                result = BlobStoreFixture.loadAndTransformProps(cfgFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (Map.Entry e : Maps.fromProperties((Properties)System.getProperties()).entrySet()) {
            String key = (String)e.getKey();
            if (!key.startsWith("ds.") && !key.startsWith("bs.")) continue;
            key = key.substring(3);
            result.put(key, e.getValue());
        }
        return result;
    }
}

