/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.fixture;

import com.mongodb.MongoClientURI;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.composite.CompositeNodeStore;
import org.apache.jackrabbit.oak.composite.InitialContentMigrator;
import org.apache.jackrabbit.oak.composite.checks.NamespacePrefixNodestoreChecker;
import org.apache.jackrabbit.oak.composite.checks.NodeStoreChecks;
import org.apache.jackrabbit.oak.composite.checks.NodeStoreChecksService;
import org.apache.jackrabbit.oak.composite.checks.NodeTypeDefinitionNodeStoreChecker;
import org.apache.jackrabbit.oak.composite.checks.NodeTypeMountedNodeStoreChecker;
import org.apache.jackrabbit.oak.composite.checks.UniqueIndexNodeStoreChecker;
import org.apache.jackrabbit.oak.fixture.OakFixture;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.util.MongoConnection;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreBuilders;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.Mounts;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;

abstract class CompositeStoreFixture
extends OakFixture {
    private static final MountInfoProvider MOUNT_INFO_PROVIDER = Mounts.newBuilder().mount("libs", true, Arrays.asList("/oak:index/*$"), Arrays.asList("/libs", "/apps", "/jcr:system/rep:permissionStore/oak:mount-libs-crx.default")).build();

    private CompositeStoreFixture(String name) {
        super(name);
    }

    static OakFixture newCompositeMemoryFixture(String name) {
        return new CompositeStoreFixture(name){

            @Override
            protected NodeStore getNodeStore() {
                return new MemoryNodeStore();
            }

            @Override
            public void tearDownCluster() {
            }
        };
    }

    static OakFixture newCompositeSegmentFixture(String name, final File base, final int maxFileSizeMB, final int cacheSizeMB, final boolean memoryMapping) {
        return new CompositeStoreFixture(name){
            private FileStore fileStore;

            @Override
            protected NodeStore getNodeStore() throws IOException, InvalidFileStoreVersionException {
                FileStoreBuilder fsBuilder = FileStoreBuilder.fileStoreBuilder((File)new File(base, this.unique)).withMaxFileSize(maxFileSizeMB).withSegmentCacheSize(cacheSizeMB).withMemoryMapping(memoryMapping);
                this.fileStore = fsBuilder.build();
                return SegmentNodeStoreBuilders.builder((FileStore)this.fileStore).build();
            }

            @Override
            public void tearDownCluster() {
                if (this.fileStore != null) {
                    this.fileStore.close();
                }
            }
        };
    }

    static OakFixture newCompositeMongoFixture(String name, final String uri, final boolean dropDBAfterTest, final long cacheSize) {
        return new CompositeStoreFixture(name){
            private String database;
            private DocumentNodeStore ns;
            {
                super(name);
                this.database = new MongoClientURI(uri).getDatabase();
            }

            @Override
            protected NodeStore getNodeStore() {
                this.ns = ((MongoDocumentNodeStoreBuilder)((MongoDocumentNodeStoreBuilder)MongoDocumentNodeStoreBuilder.newMongoDocumentNodeStoreBuilder().memoryCacheSize(cacheSize)).setMongoDB(uri, this.database, 0)).build();
                return this.ns;
            }

            @Override
            public void tearDownCluster() {
                if (this.ns != null) {
                    this.ns.dispose();
                }
                if (dropDBAfterTest) {
                    try (MongoConnection c = new MongoConnection(uri);){
                        c.getDatabase(this.database).drop();
                    }
                }
            }
        };
    }

    protected abstract NodeStore getNodeStore() throws IOException, InvalidFileStoreVersionException;

    @Override
    public Oak getOak(int clusterId) throws Exception {
        MemoryNodeStore seed = new MemoryNodeStore();
        Oak oakSeed = new Oak((NodeStore)seed);
        this.populateSeed(oakSeed);
        NodeStore global = this.getNodeStore();
        new InitialContentMigrator(global, (NodeStore)seed, MOUNT_INFO_PROVIDER.getMountByName("libs")).migrate();
        ArrayList<Object> checkerList = new ArrayList<Object>();
        checkerList.add(new NamespacePrefixNodestoreChecker());
        checkerList.add(new NodeTypeDefinitionNodeStoreChecker());
        checkerList.add(new NodeTypeMountedNodeStoreChecker());
        checkerList.add(new UniqueIndexNodeStoreChecker());
        CompositeNodeStore composite = new CompositeNodeStore.Builder(MOUNT_INFO_PROVIDER, global).addMount("libs", (NodeStore)seed).with((NodeStoreChecks)new NodeStoreChecksService(MOUNT_INFO_PROVIDER, checkerList)).build();
        return new Oak((NodeStore)composite);
    }

    private void populateSeed(Oak oakSeed) {
    }

    @Override
    public Oak[] setUpCluster(int n, StatisticsProvider statsProvider) throws Exception {
        if (n != 1) {
            throw new IllegalArgumentException();
        }
        return new Oak[]{this.getOak(1)};
    }
}

