/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.fixture;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.google.common.base.Strings;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.oak.blob.cloud.azure.blobstorage.AzureDataStore;
import org.apache.jackrabbit.oak.blob.cloud.s3.S3DataStore;
import org.apache.jackrabbit.oak.blob.cloud.s3.Utils;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStoreUtils {
    private static final Logger log = LoggerFactory.getLogger(DataStoreUtils.class);
    private static Class S3 = S3DataStore.class;
    private static Class AZURE = AzureDataStore.class;

    public static boolean isS3DataStore(String dsName) {
        return dsName != null && dsName.equals(S3.getName());
    }

    public static boolean isAzureDataStore(String dsName) {
        return dsName != null && dsName.equals(AZURE.getName());
    }

    public static DataStore configureIfCloudDataStore(String className, DataStore ds, Map<String, ?> config, String bucket, StatisticsProvider statisticsProvider) throws Exception {
        Properties props = new Properties();
        props.putAll(config);
        log.info("Using bucket [ {} ]", (Object)bucket);
        if (DataStoreUtils.isS3DataStore(className)) {
            props.setProperty("s3Bucket", bucket);
            if (S3.getName().equals(className)) {
                ((S3DataStore)ds).setProperties(props);
                ((S3DataStore)ds).setStatisticsProvider(statisticsProvider);
            }
        } else if (DataStoreUtils.isAzureDataStore(className)) {
            props.setProperty("container", bucket);
            ((AzureDataStore)ds).setProperties(props);
            ((AzureDataStore)ds).setStatisticsProvider(statisticsProvider);
        }
        return ds;
    }

    public static void cleanup(File storeDir, Map<String, ?> config, String bucket) throws Exception {
        FileUtils.deleteQuietly((File)storeDir);
        if (config.containsKey("s3Bucket")) {
            if (!Strings.isNullOrEmpty((String)bucket)) {
                DataStoreUtils.deleteBucket(bucket, config, new Date());
            }
        } else if (config.containsKey("container")) {
            DataStoreUtils.deleteAzureContainer(config, bucket);
        }
    }

    public static void deleteBucket(String bucket, Map<String, ?> map, Date date) throws Exception {
        log.info("cleaning bucket [" + bucket + "]");
        Properties props = new Properties();
        props.putAll(map);
        AmazonS3Client s3service = Utils.openService((Properties)props);
        TransferManager tmx = new TransferManager((AmazonS3)s3service);
        if (s3service.doesBucketExist(bucket)) {
            block0: for (int i = 0; i < 4; ++i) {
                tmx.abortMultipartUploads(bucket, date);
                ObjectListing prevObjectListing = s3service.listObjects(bucket);
                while (prevObjectListing != null) {
                    ArrayList<DeleteObjectsRequest.KeyVersion> deleteList = new ArrayList<DeleteObjectsRequest.KeyVersion>();
                    for (S3ObjectSummary s3ObjSumm : prevObjectListing.getObjectSummaries()) {
                        deleteList.add(new DeleteObjectsRequest.KeyVersion(s3ObjSumm.getKey()));
                    }
                    if (deleteList.size() > 0) {
                        DeleteObjectsRequest delObjsReq = new DeleteObjectsRequest(bucket);
                        delObjsReq.setKeys(deleteList);
                        s3service.deleteObjects(delObjsReq);
                    }
                    if (!prevObjectListing.isTruncated()) continue block0;
                    prevObjectListing = s3service.listNextBatchOfObjects(prevObjectListing);
                }
            }
            s3service.deleteBucket(bucket);
            log.info("bucket [ " + bucket + "] cleaned");
        } else {
            log.info("bucket [" + bucket + "] doesn't exists");
        }
        tmx.shutdownNow();
        s3service.shutdown();
    }

    public static void deleteAzureContainer(Map<String, ?> config, String containerName) throws Exception {
        String accountName = (String)config.get("accessKey");
        String accountKey = (String)config.get("secretKey");
        if (Strings.isNullOrEmpty((String)containerName) || Strings.isNullOrEmpty((String)accountName) || Strings.isNullOrEmpty((String)accountKey)) {
            return;
        }
        log.info("deleting container [" + containerName + "]");
        CloudBlobContainer container = org.apache.jackrabbit.oak.blob.cloud.azure.blobstorage.Utils.getBlobContainer((String)org.apache.jackrabbit.oak.blob.cloud.azure.blobstorage.Utils.getConnectionString((String)accountName, (String)accountKey), (String)containerName);
        if (container.deleteIfExists()) {
            log.info("container [ " + containerName + "] deleted");
        } else {
            log.info("container [" + containerName + "] doesn't exists");
        }
    }
}

