/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run.cli;

import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.MutableClassToInstanceMap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import joptsimple.HelpFormatter;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.jackrabbit.oak.run.cli.CommonOptions;
import org.apache.jackrabbit.oak.run.cli.OakHelpFormatter;
import org.apache.jackrabbit.oak.run.cli.OptionBeans;
import org.apache.jackrabbit.oak.run.cli.OptionsBean;
import org.apache.jackrabbit.oak.run.cli.OptionsBeanFactory;
import org.apache.jackrabbit.oak.spi.whiteboard.DefaultWhiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;

public class Options {
    private final Set<OptionsBeanFactory> beanFactories = Sets.newHashSet();
    private final EnumSet<OptionBeans> oakRunOptions;
    private final ClassToInstanceMap<OptionsBean> optionBeans = MutableClassToInstanceMap.create();
    private OptionSet optionSet;
    private boolean disableSystemExit;
    private String commandName;
    private String summary;
    private String connectionString;
    private final Whiteboard whiteboard = new DefaultWhiteboard();
    private String tempDirectory;

    public Options() {
        this.oakRunOptions = EnumSet.allOf(OptionBeans.class);
    }

    public Options(OptionBeans ... options) {
        this.oakRunOptions = Sets.newEnumSet(Arrays.asList(options), OptionBeans.class);
    }

    public OptionSet parseAndConfigure(OptionParser parser, String[] args) throws IOException {
        return this.parseAndConfigure(parser, args, true);
    }

    public OptionSet parseAndConfigure(OptionParser parser, String[] args, boolean checkNonOptions) throws IOException {
        for (OptionsBeanFactory o : Iterables.concat(this.oakRunOptions, this.beanFactories)) {
            OptionsBean bean = o.newInstance(parser);
            this.optionBeans.put(bean.getClass(), (Object)bean);
        }
        parser.formatHelpWith((HelpFormatter)new OakHelpFormatter(this.optionBeans.values(), this.commandName, this.summary, this.connectionString));
        this.optionSet = parser.parse(args);
        this.configure(this.optionSet);
        this.checkForHelp(parser);
        if (checkNonOptions) {
            this.checkNonOptions();
        }
        return this.optionSet;
    }

    public OptionSet getOptionSet() {
        return this.optionSet;
    }

    public <T extends OptionsBean> T getOptionBean(Class<T> clazz) {
        Object o = this.optionBeans.get(clazz);
        Preconditions.checkNotNull((Object)o, (String)"No [%s] found in [%s]", (Object[])new Object[]{clazz.getSimpleName(), this.optionBeans});
        return (T)((OptionsBean)o);
    }

    public void registerOptionsFactory(OptionsBeanFactory factory) {
        this.beanFactories.add(factory);
    }

    public Options withDisableSystemExit() {
        this.disableSystemExit = true;
        return this;
    }

    public Options setCommandName(String commandName) {
        this.commandName = commandName;
        return this;
    }

    public Options setSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public Options setConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public Options setTempDirectory(String directory) {
        this.tempDirectory = directory;
        return this;
    }

    public String getTempDirectory() {
        return this.tempDirectory;
    }

    public CommonOptions getCommonOpts() {
        return this.getOptionBean(CommonOptions.class);
    }

    public Whiteboard getWhiteboard() {
        return this.whiteboard;
    }

    private void configure(OptionSet optionSet) {
        for (OptionsBean bean : this.optionBeans.values()) {
            bean.configure(optionSet);
        }
    }

    private void checkForHelp(OptionParser parser) throws IOException {
        if (this.optionBeans.containsKey(CommonOptions.class) && this.getCommonOpts().isHelpRequested()) {
            parser.printHelpOn((OutputStream)System.out);
            this.systemExit(0);
        }
    }

    public void checkNonOptions() throws IOException {
        if (this.optionBeans.containsKey(CommonOptions.class) && this.getCommonOpts().getNonOptions().isEmpty()) {
            System.out.println("NodeStore details not provided");
            this.systemExit(1);
        }
    }

    private void systemExit(int code) {
        if (!this.disableSystemExit) {
            System.exit(code);
        }
    }
}

