/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.fixture;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.guava.common.base.Splitter;
import org.apache.jackrabbit.guava.common.base.Strings;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.api.blob.BlobAccessProvider;
import org.apache.jackrabbit.oak.fixture.BlobStoreFixture;
import org.apache.jackrabbit.oak.fixture.CompositeStoreFixture;
import org.apache.jackrabbit.oak.fixture.SegmentTarFixture;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.LeaseCheckMode;
import org.apache.jackrabbit.oak.plugins.document.VersionGarbageCollector;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBBlobStore;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDataSourceFactory;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBOptions;
import org.apache.jackrabbit.oak.plugins.document.util.MongoConnection;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.filter.PathFilter;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OakFixture {
    public static final String OAK_MEMORY = "Oak-Memory";
    public static final String OAK_MEMORY_NS = "Oak-MemoryNS";
    public static final String OAK_MONGO = "Oak-Mongo";
    public static final String OAK_MONGO_DS = "Oak-Mongo-DS";
    public static final String OAK_MONGO_NS = "Oak-MongoNS";
    public static final String OAK_RDB = "Oak-RDB";
    public static final String OAK_RDB_DS = "Oak-RDB-DS";
    public static final String OAK_SEGMENT_TAR = "Oak-Segment-Tar";
    public static final String OAK_SEGMENT_AWS = "Oak-Segment-Aws";
    public static final String OAK_SEGMENT_AZURE = "Oak-Segment-Azure";
    public static final String OAK_SEGMENT_TAR_DS = "Oak-Segment-Tar-DS";
    public static final String OAK_SEGMENT_TAR_COLD = "Oak-Segment-Tar-Cold";
    public static final String OAK_COMPOSITE_STORE = "Oak-Composite-Store";
    public static final String OAK_COMPOSITE_MEMORY_STORE = "Oak-Composite-Memory-Store";
    public static final String OAK_COMPOSITE_MONGO_STORE = "Oak-Composite-Mongo-Store";
    private final String name;
    protected final String unique;

    protected OakFixture(String name) {
        this.name = name;
        this.unique = OakFixture.getUniqueDatabaseName(name);
    }

    public static String getUniqueDatabaseName(String name) {
        return String.format("%s-%d", name, System.currentTimeMillis());
    }

    public abstract Oak getOak(int var1) throws Exception;

    public abstract Oak[] setUpCluster(int var1, StatisticsProvider var2) throws Exception;

    public abstract void tearDownCluster();

    public String toString() {
        return this.name;
    }

    public static OakFixture getMemory(long cacheSize) {
        return OakFixture.getMemory(OAK_MEMORY, cacheSize);
    }

    public static OakFixture getMemoryNS(long cacheSize) {
        return OakFixture.getMemory(OAK_MEMORY_NS, cacheSize);
    }

    public static OakFixture getMemory(String name, long cacheSize) {
        return new OakFixture(name){

            @Override
            public Oak getOak(int clusterId) throws Exception {
                Oak oak = 1.newOak((NodeStore)new MemoryNodeStore());
                return oak;
            }

            @Override
            public Oak[] setUpCluster(int n, StatisticsProvider statsProvider) throws Exception {
                Oak[] cluster = new Oak[n];
                for (int i = 0; i < cluster.length; ++i) {
                    Oak oak;
                    cluster[i] = oak = 1.newOak((NodeStore)new MemoryNodeStore());
                }
                return cluster;
            }

            @Override
            public void tearDownCluster() {
            }
        };
    }

    public static OakFixture getMongo(String uri, boolean dropDBAfterTest, long cacheSize, boolean throttlingEnabled) {
        return OakFixture.getMongo(OAK_MONGO, uri, dropDBAfterTest, cacheSize, false, null, 0, throttlingEnabled);
    }

    public static OakFixture getMongo(String host, int port, String database, boolean dropDBAfterTest, long cacheSize, boolean throttlingEnabled) {
        return OakFixture.getMongo(OAK_MONGO, host, port, database, dropDBAfterTest, cacheSize, false, null, 0, throttlingEnabled);
    }

    public static OakFixture getMongoNS(String uri, boolean dropDBAfterTest, long cacheSize, boolean throttlingEnabled) {
        return OakFixture.getMongo(OAK_MONGO_NS, uri, dropDBAfterTest, cacheSize, false, null, 0, throttlingEnabled);
    }

    public static OakFixture getMongoNS(String host, int port, String database, boolean dropDBAfterTest, long cacheSize, boolean throttlingEnabled) {
        return OakFixture.getMongo(OAK_MONGO_NS, host, port, database, dropDBAfterTest, cacheSize, false, null, 0, throttlingEnabled);
    }

    public static OakFixture getMongo(String name, String host, int port, String database, boolean dropDBAfterTest, long cacheSize, boolean useFileDataStore, File base, int fdsCacheInMB, boolean throttlingEnabled) {
        if (database == null) {
            database = OakFixture.getUniqueDatabaseName(name);
        }
        String uri = "mongodb://" + host + ":" + port + "/" + database;
        return OakFixture.getMongo(name, uri, dropDBAfterTest, cacheSize, useFileDataStore, base, fdsCacheInMB, throttlingEnabled);
    }

    public static OakFixture getMongo(String name, String uri, boolean dropDBAfterTest, long cacheSize, boolean useDataStore, File base, int dsCacheInMB, boolean throttlingEnabled) {
        return new MongoFixture(name, uri, dropDBAfterTest, cacheSize, useDataStore, base, dsCacheInMB, throttlingEnabled);
    }

    public static OakFixture getRDB(String name, String jdbcuri, String jdbcuser, String jdbcpasswd, String tablePrefix, boolean dropDBAfterTest, long cacheSize, int vgcMaxAge) {
        return OakFixture.getRDB(name, jdbcuri, jdbcuser, jdbcpasswd, tablePrefix, dropDBAfterTest, cacheSize, false, null, 0, vgcMaxAge);
    }

    public static OakFixture getRDB(String name, final String jdbcuri, final String jdbcuser, final String jdbcpasswd, final String tablePrefix, final boolean dropDBAfterTest, final long cacheSize, final boolean useDataStore, final File base, final int dsCacheInMB, final int vgcMaxAge) {
        return new OakFixture(name){
            private DocumentNodeStore[] nodeStores;
            private VersionGarbageCollectionJob versionGarbageCollectionJob;
            private BlobStoreFixture blobStoreFixture;
            {
                super(name);
                this.versionGarbageCollectionJob = null;
            }

            private RDBOptions getOptions(boolean dropDBAFterTest, String tablePrefix2) {
                return new RDBOptions().dropTablesOnClose(dropDBAfterTest).tablePrefix(tablePrefix2);
            }

            private BlobStore getBlobStore(StatisticsProvider statsProvider) {
                try {
                    if (useDataStore) {
                        this.initializeBlobStoreFixture(statsProvider);
                        return this.blobStoreFixture.setUp();
                    }
                    DataSource ds = RDBDataSourceFactory.forJdbcUrl((String)jdbcuri, (String)jdbcuser, (String)jdbcpasswd);
                    return new RDBBlobStore(ds, this.getOptions(dropDBAfterTest, tablePrefix));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Oak getOak(int clusterId) throws Exception {
                DataSource ds = RDBDataSourceFactory.forJdbcUrl((String)jdbcuri, (String)jdbcuser, (String)jdbcpasswd);
                DocumentNodeStoreBuilder builder = ((RDBDocumentNodeStoreBuilder)((RDBDocumentNodeStoreBuilder)RDBDocumentNodeStoreBuilder.newRDBDocumentNodeStoreBuilder().setRDBConnection(ds, this.getOptions(dropDBAfterTest, tablePrefix)).memoryCacheSize(cacheSize)).setClusterId(clusterId)).setLogging(false);
                BlobStore blobStore = this.getBlobStore(StatisticsProvider.NOOP);
                if (blobStore != null) {
                    builder.setBlobStore(blobStore);
                }
                Oak oak = 2.newOak((NodeStore)builder.build());
                if (blobStore instanceof BlobAccessProvider) {
                    oak.getWhiteboard().register(BlobAccessProvider.class, (Object)((BlobAccessProvider)blobStore), Collections.EMPTY_MAP);
                }
                return oak;
            }

            @Override
            public Oak[] setUpCluster(int n, StatisticsProvider statsProvider) throws Exception {
                Oak[] cluster = new Oak[n];
                this.nodeStores = new DocumentNodeStore[cluster.length];
                for (int i = 0; i < cluster.length; ++i) {
                    BlobStore blobStore = this.getBlobStore(statsProvider);
                    DataSource ds = RDBDataSourceFactory.forJdbcUrl((String)jdbcuri, (String)jdbcuser, (String)jdbcpasswd);
                    DocumentNodeStoreBuilder builder = ((RDBDocumentNodeStoreBuilder)((RDBDocumentNodeStoreBuilder)((RDBDocumentNodeStoreBuilder)((RDBDocumentNodeStoreBuilder)RDBDocumentNodeStoreBuilder.newRDBDocumentNodeStoreBuilder().setRDBConnection(ds, this.getOptions(dropDBAfterTest, tablePrefix)).memoryCacheSize(cacheSize)).setStatisticsProvider(statsProvider)).setLeaseCheckMode(LeaseCheckMode.DISABLED)).setClusterId(i + 1)).setLogging(false);
                    if (blobStore != null) {
                        builder.setBlobStore(blobStore);
                    }
                    this.nodeStores[i] = builder.build();
                    cluster[i] = 2.newOak((NodeStore)this.nodeStores[i]);
                    if (!(blobStore instanceof BlobAccessProvider)) continue;
                    cluster[i].getWhiteboard().register(BlobAccessProvider.class, (Object)((BlobAccessProvider)blobStore), Collections.EMPTY_MAP);
                }
                if (vgcMaxAge > 0 && this.nodeStores.length >= 1) {
                    this.versionGarbageCollectionJob = new VersionGarbageCollectionJob(this.nodeStores[0], vgcMaxAge);
                    Thread t = new Thread(this.versionGarbageCollectionJob);
                    t.setDaemon(true);
                    t.start();
                }
                return cluster;
            }

            @Override
            public void tearDownCluster() {
                Object dropped = "";
                if (this.versionGarbageCollectionJob != null) {
                    this.versionGarbageCollectionJob.stop();
                }
                for (DocumentNodeStore ns : this.nodeStores) {
                    ns.dispose();
                    if (!(ns.getDocumentStore() instanceof RDBDocumentStore)) continue;
                    dropped = (String)dropped + ((RDBDocumentStore)ns.getDocumentStore()).getDroppedTables();
                }
                if (dropDBAfterTest) {
                    if (this.blobStoreFixture != null) {
                        this.blobStoreFixture.tearDown();
                    }
                    if (((String)dropped).isEmpty()) {
                        throw new RuntimeException("dropdb was set, but tables have not been dropped");
                    }
                }
            }

            private void initializeBlobStoreFixture(StatisticsProvider statsProvider) {
                if (useDataStore && this.blobStoreFixture == null) {
                    this.blobStoreFixture = BlobStoreFixture.create(base, true, dsCacheInMB, statsProvider);
                }
            }
        };
    }

    public static OakFixture getSegmentTar(String name, File base, int maxFileSizeMB, int cacheSizeMB, boolean memoryMapping, int binariesInlineThreshold, boolean useBlobStore, int dsCacheInMB, boolean withColdStandby, int syncInterval, boolean shareBlobStore, boolean secure, boolean oneShotRun) {
        SegmentTarFixture.SegmentTarFixtureBuilder builder = SegmentTarFixture.SegmentTarFixtureBuilder.segmentTarFixtureBuilder(name, base);
        builder.withMaxFileSize(maxFileSizeMB).withSegmentCacheSize(cacheSizeMB).withMemoryMapping(memoryMapping).withBinariesInlineThreshold(binariesInlineThreshold).withBlobStore(useBlobStore).withDSCacheSize(dsCacheInMB);
        return new SegmentTarFixture(builder, withColdStandby, syncInterval, shareBlobStore, secure, oneShotRun);
    }

    public static OakFixture getVanillaSegmentTar(File base, int maxFileSizeMB, int cacheSizeMB, boolean memoryMapping, int binariesInlineThreshold) {
        return OakFixture.getSegmentTar(OAK_SEGMENT_TAR, base, maxFileSizeMB, cacheSizeMB, memoryMapping, binariesInlineThreshold, false, 0, false, -1, false, false, false);
    }

    public static OakFixture getVanillaSegmentTar(File base, int maxFileSizeMB, int cacheSizeMB, boolean memoryMapping) {
        return OakFixture.getVanillaSegmentTar(base, maxFileSizeMB, cacheSizeMB, memoryMapping, 16512);
    }

    public static OakFixture getSegmentTarWithDataStore(File base, int maxFileSizeMB, int cacheSizeMB, boolean memoryMapping, int binariesInlineThreshold, int dsCacheInMB) {
        return OakFixture.getSegmentTar(OAK_SEGMENT_TAR_DS, base, maxFileSizeMB, cacheSizeMB, memoryMapping, binariesInlineThreshold, true, dsCacheInMB, false, -1, false, false, false);
    }

    public static OakFixture getSegmentTarWithColdStandby(File base, int maxFileSizeMB, int cacheSizeMB, boolean memoryMapping, int binariesInlineThreshold, boolean useBlobStore, int dsCacheInMB, int syncInterval, boolean shareBlobStore, boolean secure, boolean oneShotRun) {
        return OakFixture.getSegmentTar(OAK_SEGMENT_TAR_COLD, base, maxFileSizeMB, cacheSizeMB, memoryMapping, binariesInlineThreshold, useBlobStore, dsCacheInMB, true, syncInterval, shareBlobStore, secure, oneShotRun);
    }

    public static OakFixture getSegmentTarWithAwsSegmentStore(File base, String awsBucketName, String awsRootPath, String awsJournalTableName, String awsLockTableName, int maxFileSizeMB, int cacheSizeMB, int binariesInlineThreshold, boolean useBlobStore, int dsCacheInMB) {
        return SegmentTarFixture.SegmentTarFixtureBuilder.segmentTarFixtureBuilder(OAK_SEGMENT_AWS, base).withAws(awsBucketName, awsRootPath, awsJournalTableName, awsLockTableName).withMaxFileSize(maxFileSizeMB).withSegmentCacheSize(cacheSizeMB).withBinariesInlineThreshold(binariesInlineThreshold).withBlobStore(useBlobStore).withDSCacheSize(dsCacheInMB).build();
    }

    public static OakFixture getSegmentTarWithAzureSegmentStore(File base, String azureConnectionString, String azureContainerName, String azureRootPath, int maxFileSizeMB, int cacheSizeMB, int binariesInlineThreshold, boolean useBlobStore, int dsCacheInMB) {
        return SegmentTarFixture.SegmentTarFixtureBuilder.segmentTarFixtureBuilder(OAK_SEGMENT_AZURE, base).withAzure(azureConnectionString, azureContainerName, azureRootPath).withMaxFileSize(maxFileSizeMB).withSegmentCacheSize(cacheSizeMB).withBinariesInlineThreshold(binariesInlineThreshold).withBlobStore(useBlobStore).withDSCacheSize(dsCacheInMB).build();
    }

    public static OakFixture getCompositeStore(String name, File base, int maxFileSizeMB, int cacheSizeMB, boolean memoryMapping, int binariesInlineThreshold) {
        return CompositeStoreFixture.newCompositeSegmentFixture(name, base, maxFileSizeMB, cacheSizeMB, memoryMapping, binariesInlineThreshold);
    }

    public static OakFixture getCompositeMemoryStore(String name) {
        return CompositeStoreFixture.newCompositeMemoryFixture(name);
    }

    public static OakFixture getCompositeMongoStore(String name, String uri, long cacheSize, boolean dropDBAfterTest, boolean throttlingEnabled) {
        return CompositeStoreFixture.newCompositeMongoFixture(name, uri, dropDBAfterTest, cacheSize, throttlingEnabled);
    }

    static Oak newOak(NodeStore nodeStore) {
        return new Oak(nodeStore).with(ManagementFactory.getPlatformMBeanServer());
    }

    public static class MongoFixture
    extends OakFixture {
        private static final String PERSISTENT_CACHE = System.getProperty("oak.documentstore.persistentCache", "target/persistentCache,time");
        private final String uri;
        private final boolean dropDBAfterTest;
        private final long cacheSize;
        private final boolean useDataStore;
        private final File base;
        private final int dsCacheInMB;
        private final boolean throttlingEnabled;
        private List<DocumentNodeStore> nodeStores = new ArrayList<DocumentNodeStore>();
        private BlobStoreFixture blobStoreFixture;
        private BlobStore blobStore;

        public MongoFixture(String name, String uri, boolean dropDBAfterTest, long cacheSize, boolean useDataStore, File base, int dsCacheInMB, boolean throttlingEnabled) {
            super(name);
            this.uri = uri;
            this.dropDBAfterTest = dropDBAfterTest;
            this.cacheSize = cacheSize;
            this.useDataStore = useDataStore;
            this.base = base;
            this.dsCacheInMB = dsCacheInMB;
            this.throttlingEnabled = throttlingEnabled;
        }

        public DocumentNodeStoreBuilder<?> getBuilder(int clusterId) {
            MongoConnection mongo = new MongoConnection(this.uri);
            DocumentNodeStoreBuilder builder = ((MongoDocumentNodeStoreBuilder)((MongoDocumentNodeStoreBuilder)((MongoDocumentNodeStoreBuilder)((MongoDocumentNodeStoreBuilder)new MongoDocumentNodeStoreBuilder(){

                public DocumentNodeStore build() {
                    DocumentNodeStore ns = super.build();
                    nodeStores.add(ns);
                    return ns;
                }
            }.setMongoDB(mongo.getMongoClient(), mongo.getDBName())).memoryCacheSize(this.cacheSize)).setClusterId(clusterId)).setLogging(false)).setThrottlingEnabled(this.throttlingEnabled);
            this.configurePersistentCache(builder);
            this.setupBlobStore(builder, StatisticsProvider.NOOP);
            return builder;
        }

        @Override
        public Oak getOak(int clusterId) throws Exception {
            Oak oak = MongoFixture.newOak((NodeStore)this.getBuilder(clusterId).build());
            if (this.blobStore instanceof BlobAccessProvider) {
                oak.getWhiteboard().register(BlobAccessProvider.class, (Object)((BlobAccessProvider)this.blobStore), Collections.EMPTY_MAP);
            }
            return oak;
        }

        public Oak[] setUpCluster(DocumentNodeStoreBuilder<?>[] builders, StatisticsProvider statsProvider) throws Exception {
            Oak[] cluster = new Oak[builders.length];
            for (int i = 0; i < cluster.length; ++i) {
                cluster[i] = MongoFixture.newOak((NodeStore)builders[i].build());
                if (!(this.blobStore instanceof BlobAccessProvider)) continue;
                cluster[i].getWhiteboard().register(BlobAccessProvider.class, (Object)((BlobAccessProvider)this.blobStore), Collections.EMPTY_MAP);
            }
            return cluster;
        }

        @Override
        public Oak[] setUpCluster(int n, StatisticsProvider statsProvider) throws Exception {
            DocumentNodeStoreBuilder[] builders = new DocumentNodeStoreBuilder[n];
            for (int i = 0; i < n; ++i) {
                builders[i] = this.getBuilder(i + 1);
            }
            return this.setUpCluster(builders, statsProvider);
        }

        @Override
        public void tearDownCluster() {
            for (DocumentNodeStore ns : this.nodeStores) {
                ns.dispose();
            }
            this.nodeStores.clear();
            if (this.dropDBAfterTest) {
                try {
                    MongoConnection mongo = new MongoConnection(this.uri);
                    mongo.getDatabase().drop();
                    mongo.close();
                    if (this.blobStoreFixture != null) {
                        this.blobStoreFixture.tearDown();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private void setupBlobStore(DocumentNodeStoreBuilder<?> builder, StatisticsProvider statsProvider) {
            this.initializeBlobStoreFixture(statsProvider);
            if (this.blobStoreFixture != null) {
                this.blobStore = this.blobStoreFixture.setUp();
                builder.setBlobStore(this.blobStore);
            }
        }

        private void initializeBlobStoreFixture(StatisticsProvider statsProvider) {
            if (this.blobStoreFixture != null) {
                return;
            }
            if (this.useDataStore) {
                this.blobStoreFixture = BlobStoreFixture.create(this.base, true, this.dsCacheInMB, statsProvider);
            }
        }

        private void configurePersistentCache(DocumentNodeStoreBuilder<?> builder) {
            if (!"".equals(PERSISTENT_CACHE)) {
                builder.setPersistentCache(PERSISTENT_CACHE);
            }
            String persistentCacheIncludes = System.getProperty("persistentCacheIncludes");
            HashSet<String> paths = new HashSet<String>();
            if (persistentCacheIncludes != null) {
                for (String p : Splitter.on((char)',').split((CharSequence)persistentCacheIncludes)) {
                    p = p != null ? Strings.emptyToNull((String)p.trim()) : null;
                    if (p == null) continue;
                    paths.add(p);
                }
                PathFilter pf = new PathFilter(paths, Collections.emptyList());
                System.out.println("Configuring persistent cache to only cache nodes under paths " + paths);
                Predicate cachePredicate = path -> path != null && pf.filter(path) == PathFilter.Result.INCLUDE;
                builder.setNodeCachePredicate(cachePredicate);
            }
        }
    }

    private static class VersionGarbageCollectionJob
    implements Runnable {
        private static final Logger LOG = LoggerFactory.getLogger(OakFixture.class);
        private boolean stopped = false;
        final VersionGarbageCollector vgc;
        final long maxAge;

        public VersionGarbageCollectionJob(DocumentNodeStore dns, long maxAge) {
            this.vgc = dns.getVersionGarbageCollector();
            this.maxAge = maxAge;
        }

        @Override
        public void run() {
            while (!this.stopped) {
                try {
                    VersionGarbageCollector.VersionGCStats stats = this.vgc.gc(this.maxAge, TimeUnit.SECONDS);
                    LOG.debug("vgc: " + stats);
                    Thread.sleep(5000L);
                }
                catch (Throwable ex) {
                    LOG.warn("While running GC", ex);
                }
            }
        }

        public void stop() {
            this.vgc.cancel();
            this.stopped = true;
        }
    }
}

