/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.fixture;

import java.io.File;
import java.util.Collections;
import javax.jcr.Repository;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.fixture.JcrCreator;
import org.apache.jackrabbit.oak.fixture.OakFixture;
import org.apache.jackrabbit.oak.fixture.RepositoryFixture;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;

public class OakRepositoryFixture
implements RepositoryFixture {
    private final OakFixture oakFixture;
    private StatisticsProvider statisticsProvider = StatisticsProvider.NOOP;
    private Repository[] cluster;

    public static RepositoryFixture getMemoryNS(long cacheSize) {
        return OakRepositoryFixture.getMemory("Oak-MemoryNS", cacheSize);
    }

    private static RepositoryFixture getMemory(String name, long cacheSize) {
        return new OakRepositoryFixture(OakFixture.getMemory(name, cacheSize));
    }

    public static RepositoryFixture getMongo(String host, int port, String database, boolean dropDBAfterTest, long cacheSize, boolean throttlingEnabled) {
        return OakRepositoryFixture.getMongo("Oak-Mongo", host, port, database, dropDBAfterTest, cacheSize, false, null, 0, throttlingEnabled);
    }

    public static RepositoryFixture getMongo(String uri, boolean dropDBAfterTest, long cacheSize, boolean throttlingEnabled) {
        return OakRepositoryFixture.getMongoNS(uri, dropDBAfterTest, cacheSize, throttlingEnabled);
    }

    public static RepositoryFixture getMongoWithDS(String host, int port, String database, boolean dropDBAfterTest, long cacheSize, File base, int fdsCacheInMB, boolean throttlingEnabled) {
        return OakRepositoryFixture.getMongo("Oak-Mongo-DS", host, port, database, dropDBAfterTest, cacheSize, true, base, fdsCacheInMB, throttlingEnabled);
    }

    public static RepositoryFixture getMongoWithDS(String uri, boolean dropDBAfterTest, long cacheSize, File base, int fdsCacheInMB, boolean throttlingEnabled) {
        return new OakRepositoryFixture(OakFixture.getMongo("Oak-Mongo-DS", uri, dropDBAfterTest, cacheSize, true, base, fdsCacheInMB, throttlingEnabled));
    }

    public static RepositoryFixture getMongoNS(String host, int port, String database, boolean dropDBAfterTest, long cacheSize, boolean throttlingEnabled) {
        return OakRepositoryFixture.getMongo("Oak-MongoNS", host, port, database, dropDBAfterTest, cacheSize, false, null, 0, throttlingEnabled);
    }

    public static RepositoryFixture getMongoNS(String uri, boolean dropDBAfterTest, long cacheSize, boolean throttlingEnabled) {
        return new OakRepositoryFixture(OakFixture.getMongo(uri, dropDBAfterTest, cacheSize, throttlingEnabled));
    }

    private static RepositoryFixture getMongo(String name, String host, int port, String database, boolean dropDBAfterTest, long cacheSize, boolean useFileDataStore, File base, int fdsCacheInMB, boolean throttlingEnabled) {
        return new OakRepositoryFixture(OakFixture.getMongo(name, host, port, database, dropDBAfterTest, cacheSize, useFileDataStore, base, fdsCacheInMB, throttlingEnabled));
    }

    public static RepositoryFixture getRDB(String jdbcuri, String jdbcuser, String jdbcpasswd, String jdbctableprefix, boolean dropDBAfterTest, long cacheSize, int vgcMaxAge) {
        return new OakRepositoryFixture(OakFixture.getRDB("Oak-RDB", jdbcuri, jdbcuser, jdbcpasswd, jdbctableprefix, dropDBAfterTest, cacheSize, vgcMaxAge));
    }

    public static RepositoryFixture getRDBWithDS(String jdbcuri, String jdbcuser, String jdbcpasswd, String jdbctableprefix, boolean dropDBAfterTest, long cacheSize, File base, int fdsCacheInMB, int vgcMaxAge) {
        return new OakRepositoryFixture(OakFixture.getRDB("Oak-RDB-DS", jdbcuri, jdbcuser, jdbcpasswd, jdbctableprefix, dropDBAfterTest, cacheSize, true, base, fdsCacheInMB, vgcMaxAge));
    }

    public static RepositoryFixture getSegmentTar(File base, int maxFileSizeMB, int cacheSizeMB, boolean memoryMapping, int binariesInlineThreshold) {
        return new OakRepositoryFixture(OakFixture.getVanillaSegmentTar(base, maxFileSizeMB, cacheSizeMB, memoryMapping, binariesInlineThreshold));
    }

    public static RepositoryFixture getSegmentTarWithDataStore(File base, int maxFileSizeMB, int cacheSizeMB, boolean memoryMapping, int binariesInlineThreshold, int dsCacheInMB) {
        return new OakRepositoryFixture(OakFixture.getSegmentTarWithDataStore(base, maxFileSizeMB, cacheSizeMB, memoryMapping, binariesInlineThreshold, dsCacheInMB));
    }

    public static RepositoryFixture getSegmentTarWithColdStandby(File base, int maxFileSizeMB, int cacheSizeMB, boolean memoryMapping, int binariesInlineThreshold, boolean useBlobStore, int dsCacheInMB, int syncInterval, boolean shareBlobStore, boolean secure, boolean oneShotRun) {
        return new OakRepositoryFixture(OakFixture.getSegmentTarWithColdStandby(base, maxFileSizeMB, cacheSizeMB, memoryMapping, binariesInlineThreshold, useBlobStore, dsCacheInMB, syncInterval, shareBlobStore, secure, oneShotRun));
    }

    public static RepositoryFixture getSegmentTarWithAwsSegmentStore(File base, String awsBucketName, String awsRootPath, String awsJournalTableName, String awsLockTableName, int maxFileSizeMB, int cacheSizeMB, int binariesInlineThreshold, boolean useBlobStore, int dsCacheInMB) {
        return new OakRepositoryFixture(OakFixture.getSegmentTarWithAwsSegmentStore(base, awsBucketName, awsRootPath, awsJournalTableName, awsLockTableName, maxFileSizeMB, cacheSizeMB, binariesInlineThreshold, useBlobStore, dsCacheInMB));
    }

    public static RepositoryFixture getSegmentTarWithAzureSegmentStore(File base, String azureConnectionString, String azureContainerName, String azureRootPath, int maxFileSizeMB, int cacheSizeMB, int binariesInlineThreshold, boolean useBlobStore, int dsCacheInMB) {
        return new OakRepositoryFixture(OakFixture.getSegmentTarWithAzureSegmentStore(base, azureConnectionString, azureContainerName, azureRootPath, maxFileSizeMB, cacheSizeMB, binariesInlineThreshold, useBlobStore, dsCacheInMB));
    }

    public static RepositoryFixture getCompositeStore(File base, int maxFileSizeMB, int cacheSizeMB, boolean memoryMapping, int binariesInlineThreshold) {
        return new OakRepositoryFixture(OakFixture.getCompositeStore("Oak-Composite-Store", base, maxFileSizeMB, cacheSizeMB, memoryMapping, binariesInlineThreshold));
    }

    public static RepositoryFixture getCompositeMemoryStore() {
        return new OakRepositoryFixture(OakFixture.getCompositeMemoryStore("Oak-Composite-Memory-Store"));
    }

    public static RepositoryFixture getCompositeMongoStore(String uri, long cacheSize, boolean dropDBAfterTest, boolean throttlingEnabled) {
        return new OakRepositoryFixture(OakFixture.getCompositeMongoStore("Oak-Composite-Mongo-Store", uri, cacheSize, dropDBAfterTest, throttlingEnabled));
    }

    protected OakRepositoryFixture(OakFixture oakFixture) {
        this.oakFixture = oakFixture;
    }

    @Override
    public boolean isAvailable(int n) {
        return true;
    }

    @Override
    public final Repository[] setUpCluster(int n) throws Exception {
        return this.setUpCluster(n, JcrCreator.DEFAULT);
    }

    public Repository[] setUpCluster(int n, JcrCreator customizer) throws Exception {
        Oak[] oaks = this.oakFixture.setUpCluster(n, this.statisticsProvider);
        this.cluster = new Repository[oaks.length];
        for (int i = 0; i < oaks.length; ++i) {
            this.configureStatsProvider(oaks[i]);
            this.cluster[i] = customizer.customize(oaks[i]).createRepository();
        }
        return this.cluster;
    }

    @Override
    public void syncRepositoryCluster(Repository ... nodes) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public void tearDownCluster() {
        if (this.cluster != null) {
            for (Repository repo : this.cluster) {
                if (!(repo instanceof JackrabbitRepository)) continue;
                ((JackrabbitRepository)repo).shutdown();
            }
        }
        this.oakFixture.tearDownCluster();
    }

    public String toString() {
        return this.oakFixture.toString();
    }

    public OakFixture getOakFixture() {
        return this.oakFixture;
    }

    public void setStatisticsProvider(StatisticsProvider statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
    }

    private void configureStatsProvider(Oak oak) {
        oak.getWhiteboard().register(StatisticsProvider.class, (Object)this.statisticsProvider, Collections.emptyMap());
    }
}

