/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index;

import java.io.File;
import java.io.IOException;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.index.IndexHelper;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.importer.AsyncIndexerLock;
import org.apache.jackrabbit.oak.plugins.index.importer.ClusterNodeStoreLock;
import org.apache.jackrabbit.oak.plugins.index.importer.IndexImporter;
import org.apache.jackrabbit.oak.spi.state.Clusterable;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

public abstract class IndexImporterSupportBase {
    protected final NodeStore nodeStore;
    protected final IndexHelper indexHelper;

    public IndexImporterSupportBase(IndexHelper indexHelper) {
        this.nodeStore = indexHelper.getNodeStore();
        this.indexHelper = indexHelper;
    }

    public void importIndex(File importDir) throws IOException, CommitFailedException {
        IndexImporter importer = new IndexImporter(this.nodeStore, importDir, this.createIndexEditorProvider(), this.createLock(), this.indexHelper.getStatisticsProvider());
        this.addImportProviders(importer);
        importer.importIndex();
    }

    private AsyncIndexerLock createLock() {
        if (this.nodeStore instanceof Clusterable) {
            return new ClusterNodeStoreLock(this.nodeStore);
        }
        return AsyncIndexerLock.NOOP_LOCK;
    }

    protected abstract IndexEditorProvider createIndexEditorProvider() throws IOException;

    protected abstract void addImportProviders(IndexImporter var1);
}

