/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.index.IndexHelper;
import org.apache.jackrabbit.oak.index.PrinterDumper;
import org.apache.jackrabbit.oak.plugins.index.importer.AsyncLaneSwitcher;
import org.apache.jackrabbit.oak.plugins.index.importer.IndexDefinitionUpdater;
import org.apache.jackrabbit.oak.plugins.index.importer.IndexerInfo;
import org.apache.jackrabbit.oak.plugins.index.inventory.IndexDefinitionPrinter;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.filter.PathFilter;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexerSupport {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String LOCAL_INDEX_ROOT_DIR = "indexes";
    private static final String HEAD_AS_CHECKPOINT = "head";
    private static final String REINDEX_LANE = "offline-reindex-async";
    private Map<String, String> checkpointInfo = Collections.emptyMap();
    protected final IndexHelper indexHelper;
    private File localIndexDir;
    private File indexDefinitions;
    private final String checkpoint;
    private File existingDataDumpDir;

    public IndexerSupport(IndexHelper indexHelper, String checkpoint) {
        this.indexHelper = indexHelper;
        this.checkpoint = checkpoint;
    }

    public IndexerSupport withExistingDataDumpDir(File existingDataDumpDir) {
        this.existingDataDumpDir = existingDataDumpDir;
        return this;
    }

    public File getExistingDataDumpDir() {
        return this.existingDataDumpDir;
    }

    public File getLocalIndexDir() throws IOException {
        if (this.localIndexDir == null) {
            this.localIndexDir = new File(this.indexHelper.getWorkDir(), LOCAL_INDEX_ROOT_DIR);
            FileUtils.forceMkdir((File)this.localIndexDir);
        }
        return this.localIndexDir;
    }

    public File copyIndexFilesToOutput() throws IOException {
        File destDir = new File(this.indexHelper.getOutputDir(), this.getLocalIndexDir().getName());
        FileUtils.moveDirectoryToDirectory((File)this.getLocalIndexDir(), (File)this.indexHelper.getOutputDir(), (boolean)true);
        return destDir;
    }

    public void writeMetaInfo(String checkpoint) throws IOException {
        new IndexerInfo(this.getLocalIndexDir(), checkpoint).save();
    }

    public String getCheckpoint() {
        return this.checkpoint;
    }

    public NodeState retrieveNodeStateForCheckpoint() {
        NodeState checkpointedState;
        if (HEAD_AS_CHECKPOINT.equals(this.checkpoint)) {
            checkpointedState = this.indexHelper.getNodeStore().getRoot();
            this.log.warn("Using head state for indexing. Such an index cannot be imported back");
        } else {
            checkpointedState = this.indexHelper.getNodeStore().retrieve(this.checkpoint);
            Preconditions.checkNotNull((Object)checkpointedState, (String)"Not able to retrieve revision referred via checkpoint [%s]", (Object)this.checkpoint);
            this.checkpointInfo = this.indexHelper.getNodeStore().checkpointInfo(this.checkpoint);
        }
        return checkpointedState;
    }

    public void updateIndexDefinitions(NodeBuilder rootBuilder) throws IOException, CommitFailedException {
        if (this.indexDefinitions != null) {
            new IndexDefinitionUpdater(this.indexDefinitions).apply(rootBuilder);
        }
    }

    protected void dumpIndexDefinitions(NodeStore nodeStore) throws IOException {
        IndexDefinitionPrinter printer = new IndexDefinitionPrinter(nodeStore, this.indexHelper.getIndexPathService());
        printer.setFilter("{\"properties\":[\"*\", \"-:childOrder\"],\"nodes\":[\"*\", \"-:index-definition\", \"-:data\", \"-:suggest-data\"]}");
        PrinterDumper dumper = new PrinterDumper(this.getLocalIndexDir(), "index-definitions.json", false, Format.JSON, (InventoryPrinter)printer);
        dumper.dump();
    }

    public void switchIndexLanesAndReindexFlag(NodeStore copyOnWriteStore) throws CommitFailedException, IOException {
        NodeState root = copyOnWriteStore.getRoot();
        NodeBuilder builder = root.builder();
        this.updateIndexDefinitions(builder);
        for (String indexPath : this.indexHelper.getIndexPaths()) {
            NodeBuilder idxBuilder = IndexerSupport.childBuilder(builder, indexPath, false);
            Preconditions.checkState((boolean)idxBuilder.exists(), (String)"No index definition found at path [%s]", (Object)indexPath);
            idxBuilder.setProperty("reindex", (Object)true);
            AsyncLaneSwitcher.switchLane((NodeBuilder)idxBuilder, (String)REINDEX_LANE);
        }
        copyOnWriteStore.merge(builder, EmptyHook.INSTANCE, CommitInfo.EMPTY);
        this.log.info("Switched the async lane for indexes at {} to {} and marked them for reindex", this.indexHelper.getIndexPaths(), (Object)REINDEX_LANE);
    }

    public void postIndexWork(NodeStore copyOnWriteStore) throws CommitFailedException, IOException {
        this.switchIndexLanesBack(copyOnWriteStore);
        this.dumpIndexDefinitions(copyOnWriteStore);
    }

    protected void switchIndexLanesBack(NodeStore copyOnWriteStore) throws CommitFailedException {
        NodeState root = copyOnWriteStore.getRoot();
        NodeBuilder builder = root.builder();
        for (String indexPath : this.indexHelper.getIndexPaths()) {
            NodeBuilder idxBuilder = IndexerSupport.childBuilder(builder, indexPath, false);
            AsyncLaneSwitcher.revertSwitch((NodeBuilder)idxBuilder, (String)indexPath);
        }
        copyOnWriteStore.merge(builder, EmptyHook.INSTANCE, CommitInfo.EMPTY);
        this.log.info("Switched the async lane for indexes at {} back to there original lanes", this.indexHelper.getIndexPaths());
    }

    public Map<String, String> getCheckpointInfo() {
        return this.checkpointInfo;
    }

    public void setIndexDefinitions(File indexDefinitions) {
        this.indexDefinitions = indexDefinitions;
    }

    public static NodeBuilder childBuilder(NodeBuilder nb, String path, boolean createNew) {
        for (String name : PathUtils.elements((String)((String)Preconditions.checkNotNull((Object)path)))) {
            nb = createNew ? nb.child(name) : nb.getChildNode(name);
        }
        return nb;
    }

    public Set<IndexDefinition> getIndexDefinitions() throws IOException, CommitFailedException {
        NodeState checkpointedState = this.retrieveNodeStateForCheckpoint();
        MemoryNodeStore copyOnWriteStore = new MemoryNodeStore(checkpointedState);
        NodeBuilder builder = copyOnWriteStore.getRoot().builder();
        NodeState root = builder.getNodeState();
        this.updateIndexDefinitions(builder);
        IndexDefinition.Builder indexDefBuilder = new IndexDefinition.Builder();
        HashSet<IndexDefinition> indexDefinitions = new HashSet<IndexDefinition>();
        for (String indexPath : this.indexHelper.getIndexPaths()) {
            NodeBuilder idxBuilder = IndexerSupport.childBuilder(builder, indexPath, false);
            IndexDefinition indexDf = indexDefBuilder.defn(idxBuilder.getNodeState()).indexPath(indexPath).root(root).build();
            indexDefinitions.add(indexDf);
        }
        return indexDefinitions;
    }

    public Set<String> getPreferredPathElements(Set<IndexDefinition> indexDefinitions) {
        HashSet<String> preferredPathElements = new HashSet<String>();
        for (IndexDefinition indexDf : indexDefinitions) {
            preferredPathElements.addAll(indexDf.getRelativeNodeNames());
        }
        return preferredPathElements;
    }

    public <T> Predicate<T> getFilterPredicate(Set<IndexDefinition> indexDefinitions, Function<T, String> typeToRepositoryPath) {
        return t -> indexDefinitions.stream().anyMatch(indexDef -> indexDef.getPathFilter().filter((String)typeToRepositoryPath.apply(t)) != PathFilter.Result.EXCLUDE);
    }
}

