/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.jackrabbit.guava.common.base.Preconditions;

class PrinterDumper {
    private final File outDir;
    private final String fileName;
    private final boolean dumpToSysOut;
    private final Format format;
    private final InventoryPrinter printer;
    private File outFile;

    public PrinterDumper(File outDir, String fileName, boolean dumpToSysOut, Format format, InventoryPrinter printer) {
        this.outDir = outDir;
        this.fileName = fileName;
        this.dumpToSysOut = dumpToSysOut;
        this.format = format;
        this.printer = printer;
    }

    public void dump() throws IOException {
        try (OutputStream os = this.newOutput();){
            OutputStream writerStream = this.dumpToSysOut ? new TeeOutputStream(os, (OutputStream)System.out) : os;
            PrintWriter pw = new PrintWriter(writerStream);
            this.printer.print(pw, this.format, false);
            pw.flush();
        }
    }

    public File getOutFile() {
        return (File)Preconditions.checkNotNull((Object)this.outFile);
    }

    private OutputStream newOutput() throws IOException {
        this.outFile = new File(this.outDir, this.fileName);
        return new BufferedOutputStream(FileUtils.openOutputStream((File)this.outFile));
    }
}

