/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.async;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.guava.common.io.Closer;
import org.apache.jackrabbit.oak.index.IndexHelper;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexUpdate;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncIndexerBase
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(AsyncIndexerBase.class);
    private final IndexHelper indexHelper;
    protected final Closer closer;
    private final List<String> names;
    private static final long INIT_DELAY = 0L;
    private final long delay;
    private final ScheduledExecutorService pool;
    private final CountDownLatch latch;

    public AsyncIndexerBase(IndexHelper indexHelper, Closer closer, List<String> names, long delay) {
        this.indexHelper = indexHelper;
        this.closer = closer;
        this.names = names;
        this.delay = delay;
        this.pool = Executors.newScheduledThreadPool(names.size());
        this.latch = new CountDownLatch(1);
    }

    public void execute() throws InterruptedException, IOException {
        this.addShutDownHook();
        IndexEditorProvider editorProvider = this.getIndexEditorProvider();
        if (editorProvider == null) {
            log.error("EditorProvider is null, can't proceed further. Exiting");
            this.closer.close();
        }
        for (String name : this.names) {
            log.info("Setting up Async executor for lane - " + name);
            AsyncIndexUpdate task = new AsyncIndexUpdate(name, this.indexHelper.getNodeStore(), editorProvider, StatisticsProvider.NOOP, false);
            this.closer.register((Closeable)task);
            this.pool.scheduleWithFixedDelay((Runnable)task, 0L, this.delay, TimeUnit.SECONDS);
        }
        this.latch.await();
    }

    @Override
    public void close() throws IOException {
        log.info("Closing down Async Indexer Service...");
        this.latch.countDown();
        this.pool.shutdown();
    }

    private void addShutDownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    AsyncIndexerBase.this.closer.close();
                }
                catch (IOException e) {
                    log.error("Exception during cleanup ", (Throwable)e);
                }
            }
        });
    }

    public abstract IndexEditorProvider getIndexEditorProvider();
}

