/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document;

import com.codahale.metrics.MetricRegistry;
import com.mongodb.client.MongoDatabase;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.base.Stopwatch;
import org.apache.jackrabbit.guava.common.io.Closer;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.commons.concurrent.ExecutorCloser;
import org.apache.jackrabbit.oak.index.IndexHelper;
import org.apache.jackrabbit.oak.index.IndexerSupport;
import org.apache.jackrabbit.oak.index.indexer.document.CompositeException;
import org.apache.jackrabbit.oak.index.indexer.document.CompositeIndexer;
import org.apache.jackrabbit.oak.index.indexer.document.IndexerConfiguration;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntry;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntryTraverser;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntryTraverserFactory;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateIndexer;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateIndexerProvider;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.DefaultMemoryManager;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.FlatFileNodeStoreBuilder;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.FlatFileStore;
import org.apache.jackrabbit.oak.index.indexer.document.incrementalstore.IncrementalStoreBuilder;
import org.apache.jackrabbit.oak.index.indexer.document.indexstore.IndexStore;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.mongo.DocumentStoreSplitter;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.TraversingRange;
import org.apache.jackrabbit.oak.plugins.document.util.MongoConnection;
import org.apache.jackrabbit.oak.plugins.index.FormattingUtils;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.MetricsFormatter;
import org.apache.jackrabbit.oak.plugins.index.MetricsUtils;
import org.apache.jackrabbit.oak.plugins.index.NodeTraversalCallback;
import org.apache.jackrabbit.oak.plugins.index.progress.IndexingProgressReporter;
import org.apache.jackrabbit.oak.plugins.index.progress.MetricRateEstimator;
import org.apache.jackrabbit.oak.plugins.index.progress.TraversalRateEstimator;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.plugins.metric.MetricStatisticsProvider;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DocumentStoreIndexerBase
implements Closeable {
    public static final String INDEXER_METRICS_PREFIX = "oak_indexer_";
    public static final String METRIC_INDEXING_DURATION_SECONDS = "oak_indexer_indexing_duration_seconds";
    public static final String METRIC_MERGE_NODE_STORE_DURATION_SECONDS = "oak_indexer_merge_node_store_duration_seconds";
    public static final String METRIC_FULL_INDEX_CREATION_DURATION_SECONDS = "oak_indexer_full_index_creation_duration_seconds";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Logger traversalLog = LoggerFactory.getLogger((String)(DocumentStoreIndexerBase.class.getName() + ".traversal"));
    protected final Closer closer = Closer.create();
    protected final IndexHelper indexHelper;
    protected List<NodeStateIndexerProvider> indexerProviders;
    protected final IndexerSupport indexerSupport;
    private static final int MAX_DOWNLOAD_ATTEMPTS = Integer.parseInt(System.getProperty("oak.indexer.maxDownloadRetries", "5")) + 1;

    public DocumentStoreIndexerBase(IndexHelper indexHelper, IndexerSupport indexerSupport) {
        this.indexHelper = indexHelper;
        this.indexerSupport = indexerSupport;
    }

    protected void setProviders() throws IOException {
        this.indexerProviders = this.createProviders();
    }

    private List<FlatFileStore> buildFlatFileStoreList(NodeState checkpointedState, CompositeIndexer indexer, Predicate<String> pathPredicate, Set<String> preferredPathElements, boolean splitFlatFile, Set<IndexDefinition> indexDefinitions) throws IOException {
        List<FlatFileStore> storeList = new ArrayList<FlatFileStore>();
        Stopwatch flatFileStoreWatch = Stopwatch.createStarted();
        CompositeException lastException = null;
        ArrayList<File> previousDownloadDirs = new ArrayList<File>();
        DocumentNodeState rootDocumentState = (DocumentNodeState)checkpointedState;
        DocumentNodeStore nodeStore = (DocumentNodeStore)this.indexHelper.getNodeStore();
        DocumentStoreSplitter splitter = new DocumentStoreSplitter(this.getMongoDocumentStore());
        List<Long> lastModifiedBreakPoints = splitter.split(Collection.NODES, 0L, 10);
        FlatFileNodeStoreBuilder builder = null;
        int backOffTimeInMillis = 5000;
        DefaultMemoryManager memoryManager = new DefaultMemoryManager();
        for (int executionCount = 1; storeList.isEmpty() && executionCount <= MAX_DOWNLOAD_ATTEMPTS; ++executionCount) {
            try {
                builder = new FlatFileNodeStoreBuilder(this.indexHelper.getWorkDir(), memoryManager).withLastModifiedBreakPoints(lastModifiedBreakPoints).withBlobStore((BlobStore)this.indexHelper.getGCBlobStore()).withPreferredPathElements(preferredPathElements != null ? preferredPathElements : indexer.getRelativeIndexedNodeNames()).addExistingDataDumpDir(this.indexerSupport.getExistingDataDumpDir()).withPathPredicate(pathPredicate).withIndexDefinitions(indexDefinitions).withRootRevision(rootDocumentState.getRootRevision()).withNodeStore(nodeStore).withMongoDocumentStore(this.getMongoDocumentStore()).withMongoDatabase(this.getMongoDatabase()).withNodeStateEntryTraverserFactory(new MongoNodeStateEntryTraverserFactory(rootDocumentState.getRootRevision(), nodeStore, this.getMongoDocumentStore(), this.traversalLog)).withCheckpoint(this.indexerSupport.getCheckpoint()).withStatisticsProvider(this.indexHelper.getStatisticsProvider());
                for (File dir : previousDownloadDirs) {
                    builder.addExistingDataDumpDir(dir);
                }
                if (splitFlatFile) {
                    storeList = builder.buildList(this.indexHelper, this.indexerSupport, indexDefinitions);
                } else {
                    storeList.add(builder.build());
                }
                for (FlatFileStore item : storeList) {
                    this.closer.register((Closeable)item);
                }
                continue;
            }
            catch (CompositeException e) {
                e.logAllExceptions("Underlying throwable caught during download", this.log);
                this.log.info("Could not build flat file store. Execution count {}. Retries left {}. Time elapsed {}", new Object[]{executionCount, MAX_DOWNLOAD_ATTEMPTS - executionCount, flatFileStoreWatch});
                lastException = e;
                previousDownloadDirs.add(builder.getFlatFileStoreDir());
                if (executionCount >= MAX_DOWNLOAD_ATTEMPTS) continue;
                try {
                    this.log.info("Waiting for {} millis before retrying", (Object)backOffTimeInMillis);
                    Thread.sleep(backOffTimeInMillis);
                    backOffTimeInMillis *= 2;
                    continue;
                }
                catch (InterruptedException ie) {
                    this.log.error("Interrupted while waiting before retrying download ", (Throwable)ie);
                }
            }
        }
        if (storeList.isEmpty()) {
            throw new IOException("Could not build flat file store", lastException);
        }
        this.log.info("Completed the flat file store build in {}", (Object)flatFileStoreWatch);
        return storeList;
    }

    public IndexStore buildStore() throws IOException, CommitFailedException {
        return this.buildFlatFileStore();
    }

    public IndexStore buildStore(String initialCheckpoint, String finalCheckpoint) throws IOException, CommitFailedException {
        IndexStore incrementalStore;
        Set<IndexDefinition> indexDefinitions = this.indexerSupport.getIndexDefinitions();
        Set<String> preferredPathElements = this.indexerSupport.getPreferredPathElements(indexDefinitions);
        Stopwatch incrementalStoreWatch = Stopwatch.createStarted();
        org.apache.jackrabbit.guava.common.base.Predicate predicate = this.indexerSupport.getFilterPredicate(indexDefinitions, Function.identity());
        try {
            IncrementalStoreBuilder builder = new IncrementalStoreBuilder(this.indexHelper.getWorkDir(), this.indexHelper, initialCheckpoint, finalCheckpoint).withPreferredPathElements(preferredPathElements).withPathPredicate((Predicate<String>)predicate).withBlobStore((BlobStore)this.indexHelper.getGCBlobStore());
            incrementalStore = builder.build();
            this.closer.register((Closeable)incrementalStore);
        }
        catch (Exception e) {
            throw new IOException("Could not build incremental store", e);
        }
        this.log.info("Completed incremental store build in {}", (Object)incrementalStoreWatch);
        return incrementalStore;
    }

    @Deprecated
    public FlatFileStore buildFlatFileStore() throws IOException, CommitFailedException {
        NodeState checkpointedState = this.indexerSupport.retrieveNodeStateForCheckpoint();
        Set<IndexDefinition> indexDefinitions = this.indexerSupport.getIndexDefinitions();
        Set<String> preferredPathElements = this.indexerSupport.getPreferredPathElements(indexDefinitions);
        org.apache.jackrabbit.guava.common.base.Predicate predicate = this.indexerSupport.getFilterPredicate(indexDefinitions, Function.identity());
        FlatFileStore flatFileStore = this.buildFlatFileStoreList(checkpointedState, null, (Predicate<String>)predicate, preferredPathElements, IndexerConfiguration.parallelIndexEnabled(), indexDefinitions).get(0);
        this.log.info("FlatFileStore built at {}. To use this flatFileStore in a reindex step, set System Property-{} with value {}", new Object[]{flatFileStore.getStorePath(), "oak.indexer.sortedFilePath", flatFileStore.getStorePath()});
        return flatFileStore;
    }

    public void reindex() throws CommitFailedException, IOException {
        this.log.info("[TASK:FULL_INDEX_CREATION:START] Starting indexing job");
        Stopwatch indexJobWatch = Stopwatch.createStarted();
        IndexingProgressReporter progressReporter = new IndexingProgressReporter(IndexUpdateCallback.NOOP, NodeTraversalCallback.NOOP);
        this.configureEstimators(progressReporter);
        NodeState checkpointedState = this.indexerSupport.retrieveNodeStateForCheckpoint();
        MemoryNodeStore copyOnWriteStore = new MemoryNodeStore(checkpointedState);
        this.indexerSupport.switchIndexLanesAndReindexFlag((NodeStore)copyOnWriteStore);
        NodeBuilder builder = copyOnWriteStore.getRoot().builder();
        CompositeIndexer indexer = this.prepareIndexers((NodeStore)copyOnWriteStore, builder, progressReporter);
        if (indexer.isEmpty()) {
            return;
        }
        this.closer.register((Closeable)indexer);
        List<FlatFileStore> flatFileStores = this.buildFlatFileStoreList(checkpointedState, indexer, indexer::shouldInclude, null, IndexerConfiguration.parallelIndexEnabled(), this.indexerSupport.getIndexDefinitions());
        progressReporter.reset();
        progressReporter.reindexingTraversalStart("/");
        this.preIndexOperations(indexer.getIndexers());
        this.log.info("[TASK:INDEXING:START] Starting indexing");
        Stopwatch indexerWatch = Stopwatch.createStarted();
        if (flatFileStores.size() > 1) {
            this.indexParallel(flatFileStores, indexer, progressReporter);
        } else if (flatFileStores.size() == 1) {
            FlatFileStore flatFileStore = flatFileStores.get(0);
            for (NodeStateEntry entry : flatFileStore) {
                this.reportDocumentRead(entry.getPath(), progressReporter);
                indexer.index(entry);
            }
        }
        progressReporter.reindexingTraversalEnd();
        progressReporter.logReport();
        long indexingDurationSeconds = indexerWatch.elapsed(TimeUnit.SECONDS);
        this.log.info("Completed the indexing in {}", (Object)FormattingUtils.formatToSeconds((long)indexingDurationSeconds));
        this.log.info("[TASK:INDEXING:END] Metrics: {}", (Object)MetricsFormatter.newBuilder().add("duration", FormattingUtils.formatToSeconds((long)indexingDurationSeconds)).add("durationSeconds", indexingDurationSeconds).build());
        MetricsUtils.setCounterOnce((StatisticsProvider)this.indexHelper.getStatisticsProvider(), (String)METRIC_INDEXING_DURATION_SECONDS, (long)indexingDurationSeconds);
        this.log.info("[TASK:MERGE_NODE_STORE:START] Starting merge node store");
        Stopwatch mergeNodeStoreWatch = Stopwatch.createStarted();
        copyOnWriteStore.merge(builder, EmptyHook.INSTANCE, CommitInfo.EMPTY);
        long mergeNodeStoreDurationSeconds = mergeNodeStoreWatch.elapsed(TimeUnit.SECONDS);
        this.log.info("[TASK:MERGE_NODE_STORE:END] Metrics: {}", (Object)MetricsFormatter.newBuilder().add("duration", FormattingUtils.formatToSeconds((long)mergeNodeStoreDurationSeconds)).add("durationSeconds", mergeNodeStoreDurationSeconds).build());
        MetricsUtils.setCounterOnce((StatisticsProvider)this.indexHelper.getStatisticsProvider(), (String)METRIC_MERGE_NODE_STORE_DURATION_SECONDS, (long)mergeNodeStoreDurationSeconds);
        this.indexerSupport.postIndexWork((NodeStore)copyOnWriteStore);
        long fullIndexCreationDurationSeconds = indexJobWatch.elapsed(TimeUnit.SECONDS);
        this.log.info("[TASK:FULL_INDEX_CREATION:END] Metrics {}", (Object)MetricsFormatter.newBuilder().add("duration", FormattingUtils.formatToSeconds((long)fullIndexCreationDurationSeconds)).add("durationSeconds", fullIndexCreationDurationSeconds).build());
        MetricsUtils.setCounterOnce((StatisticsProvider)this.indexHelper.getStatisticsProvider(), (String)METRIC_FULL_INDEX_CREATION_DURATION_SECONDS, (long)fullIndexCreationDurationSeconds);
    }

    private void indexParallel(List<FlatFileStore> storeList, CompositeIndexer indexer, IndexingProgressReporter progressReporter) throws IOException {
        ExecutorService service = Executors.newFixedThreadPool(IndexerConfiguration.indexThreadPoolSize());
        ArrayList<Future<Boolean>> futureList = new ArrayList<Future<Boolean>>();
        for (FlatFileStore flatFileStore : storeList) {
            Future<Boolean> future = service.submit(() -> {
                for (NodeStateEntry entry : item) {
                    this.reportDocumentRead(entry.getPath(), progressReporter);
                    this.log.trace("Indexing : {}", (Object)entry.getPath());
                    indexer.index(entry);
                }
                return true;
            });
            futureList.add(future);
        }
        try {
            for (Future future : futureList) {
                future.get();
            }
            this.log.info("All {} indexing jobs are done", (Object)storeList.size());
        }
        catch (InterruptedException | ExecutionException e) {
            String string = "Failure getting indexing job result";
            this.log.error(string, (Throwable)e);
            throw new IOException(string, e);
        }
        finally {
            new ExecutorCloser(service).close();
        }
    }

    private MongoDocumentStore getMongoDocumentStore() {
        return (MongoDocumentStore)Preconditions.checkNotNull((Object)this.indexHelper.getService(MongoDocumentStore.class));
    }

    private MongoDatabase getMongoDatabase() {
        return (MongoDatabase)Preconditions.checkNotNull((Object)this.indexHelper.getService(MongoDatabase.class));
    }

    private void configureEstimators(IndexingProgressReporter progressReporter) {
        long nodesCount;
        StatisticsProvider statsProvider = this.indexHelper.getStatisticsProvider();
        if (statsProvider instanceof MetricStatisticsProvider) {
            MetricRegistry registry = ((MetricStatisticsProvider)statsProvider).getRegistry();
            progressReporter.setTraversalRateEstimator((TraversalRateEstimator)new MetricRateEstimator("async", registry));
        }
        if ((nodesCount = this.getEstimatedDocumentCount()) > 0L) {
            progressReporter.setNodeCountEstimator((basePath, indexPaths) -> nodesCount);
            progressReporter.setEstimatedCount(nodesCount);
            this.log.info("Estimated number of documents in Mongo are {}", (Object)nodesCount);
        }
    }

    private long getEstimatedDocumentCount() {
        MongoConnection mongoConnection = this.indexHelper.getService(MongoConnection.class);
        if (mongoConnection != null) {
            return mongoConnection.getDatabase().getCollection("nodes").count();
        }
        return 0L;
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    private void reportDocumentRead(String id, IndexingProgressReporter progressReporter) {
        try {
            progressReporter.traversedNode(() -> id);
        }
        catch (CommitFailedException e) {
            throw new RuntimeException(e);
        }
        this.traversalLog.trace(id);
    }

    protected CompositeIndexer prepareIndexers(NodeStore copyOnWriteStore, NodeBuilder builder, IndexingProgressReporter progressReporter) {
        NodeState root = copyOnWriteStore.getRoot();
        ArrayList<NodeStateIndexer> indexers = new ArrayList<NodeStateIndexer>();
        for (String indexPath : this.indexHelper.getIndexPaths()) {
            NodeState indexState = NodeStateUtils.getNode((NodeState)root, (String)indexPath);
            NodeBuilder idxBuilder = IndexerSupport.childBuilder(builder, indexPath, false);
            String type = indexState.getString("type");
            if (type == null) {
                this.log.warn("No 'type' property found on indexPath [{}]. Skipping it", (Object)indexPath);
                continue;
            }
            this.removeIndexState(idxBuilder);
            idxBuilder.setProperty("reindex", (Object)false);
            for (NodeStateIndexerProvider indexerProvider : this.indexerProviders) {
                NodeStateIndexer indexer = indexerProvider.getIndexer(type, indexPath, idxBuilder, root, progressReporter);
                if (indexer == null) continue;
                indexers.add(indexer);
                this.closer.register((Closeable)indexer);
                progressReporter.registerIndex(indexPath, true, -1L);
            }
        }
        return new CompositeIndexer(indexers);
    }

    protected abstract List<NodeStateIndexerProvider> createProviders() throws IOException;

    protected abstract void preIndexOperations(List<NodeStateIndexer> var1);

    private void removeIndexState(NodeBuilder definition) {
        for (String rm : definition.getChildNodeNames()) {
            NodeBuilder childNode;
            if (!NodeStateUtils.isHidden((String)rm) || (childNode = definition.getChildNode(rm)).getBoolean("retainNodeInReindex")) continue;
            definition.getChildNode(rm).remove();
        }
    }

    private static class MongoNodeStateEntryTraverserFactory
    implements NodeStateEntryTraverserFactory {
        private static final AtomicInteger traverserInstanceCounter = new AtomicInteger(0);
        private static final String TRAVERSER_ID_PREFIX = "NSET";
        private final RevisionVector rootRevision;
        private final DocumentNodeStore documentNodeStore;
        private final MongoDocumentStore documentStore;
        private final Logger traversalLogger;

        private MongoNodeStateEntryTraverserFactory(RevisionVector rootRevision, DocumentNodeStore documentNodeStore, MongoDocumentStore documentStore, Logger traversalLogger) {
            this.rootRevision = rootRevision;
            this.documentNodeStore = documentNodeStore;
            this.documentStore = documentStore;
            this.traversalLogger = traversalLogger;
        }

        @Override
        public NodeStateEntryTraverser create(TraversingRange traversingRange) {
            IndexingProgressReporter progressReporterPerTask = new IndexingProgressReporter(IndexUpdateCallback.NOOP, NodeTraversalCallback.NOOP);
            String entryTraverserID = TRAVERSER_ID_PREFIX + traverserInstanceCounter.incrementAndGet();
            progressReporterPerTask.setMessagePrefix("Dumping from " + entryTraverserID);
            return new NodeStateEntryTraverser(entryTraverserID, this.rootRevision, this.documentNodeStore, this.documentStore, traversingRange).withProgressCallback(id -> {
                try {
                    progressReporterPerTask.traversedNode(() -> id);
                }
                catch (CommitFailedException e) {
                    throw new RuntimeException(e);
                }
                this.traversalLogger.trace(id);
            });
        }
    }
}

