/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document;

public class IndexerConfiguration {
    public static final String PROP_OAK_INDEXER_THREAD_POOL_SIZE = "oak.indexer.threadPoolSize";
    static final int DEFAULT_OAK_INDEXER_THREAD_POOL_SIZE = 1;
    public static final String PROP_OAK_INDEXER_MIN_SPLIT_THRESHOLD = "oak.indexer.minSplitThreshold";
    static final long DEFAULT_OAK_INDEXER_MINIMUM_SPLIT_THRESHOLD = 0xA00000L;
    public static final String PROP_SPLIT_STORE_SIZE = "oak.indexer.splitStoreSize";
    static final int DEFAULT_SPLIT_STORE_SIZE = 8;
    public static final String PROP_OAK_INDEXER_PARALLEL_INDEX = "oak.indexer.parallelIndex";

    public static int indexThreadPoolSize() {
        return Integer.getInteger(PROP_OAK_INDEXER_THREAD_POOL_SIZE, 1);
    }

    public static long minSplitThreshold() {
        return Long.getLong(PROP_OAK_INDEXER_MIN_SPLIT_THRESHOLD, 0xA00000L);
    }

    public static long splitSize() {
        return Integer.getInteger(PROP_SPLIT_STORE_SIZE, 8).intValue();
    }

    public static boolean parallelIndexEnabled() {
        return Boolean.getBoolean(PROP_OAK_INDEXER_PARALLEL_INDEX);
    }
}

