/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document;

import java.util.Objects;

public class LastModifiedRange {
    private final long lastModifiedFrom;
    private final long lastModifiedTo;

    public LastModifiedRange(long lastModifiedFrom, long lastModifiedTo) {
        if (lastModifiedTo < lastModifiedFrom) {
            throw new IllegalArgumentException("Invalid range (" + lastModifiedFrom + ", " + lastModifiedTo + ")");
        }
        this.lastModifiedFrom = lastModifiedFrom;
        this.lastModifiedTo = lastModifiedTo;
    }

    public long getLastModifiedFrom() {
        return this.lastModifiedFrom;
    }

    public long getLastModifiedTo() {
        return this.lastModifiedTo;
    }

    public boolean checkOverlap(LastModifiedRange range) {
        boolean rangeOnRight = this.lastModifiedTo <= range.getLastModifiedFrom();
        boolean rangeOnLeft = range.getLastModifiedTo() <= this.lastModifiedFrom;
        return !rangeOnLeft && !rangeOnRight;
    }

    public boolean contains(Long lastModifiedValue) {
        return lastModifiedValue >= this.lastModifiedFrom && lastModifiedValue < this.lastModifiedTo;
    }

    public LastModifiedRange mergeWith(LastModifiedRange range) {
        if (!this.checkOverlap(range)) {
            throw new IllegalArgumentException("Non overlapping ranges - " + this + " and " + range);
        }
        return new LastModifiedRange(Math.min(this.lastModifiedFrom, range.lastModifiedFrom), Math.max(this.lastModifiedTo, range.lastModifiedTo));
    }

    public boolean coversAllDocuments() {
        return this.lastModifiedFrom == 0L && this.lastModifiedTo == Long.MAX_VALUE;
    }

    public String toString() {
        return "LastModifiedRange [" + this.lastModifiedFrom + ", " + this.lastModifiedTo + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LastModifiedRange that = (LastModifiedRange)o;
        return this.lastModifiedFrom == that.lastModifiedFrom && this.lastModifiedTo == that.lastModifiedTo;
    }

    public int hashCode() {
        return Objects.hash(this.lastModifiedFrom, this.lastModifiedTo);
    }
}

