/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document;

import java.util.Objects;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class NodeStateEntry {
    private final NodeState nodeState;
    private final String path;
    private final long memUsage;
    private final long lastModified;
    private final String id;

    private NodeStateEntry(NodeState nodeState, String path, long memUsage, long lastModified, String id) {
        this.nodeState = nodeState;
        this.path = path;
        this.memUsage = memUsage;
        this.lastModified = lastModified;
        this.id = id;
    }

    public NodeState getNodeState() {
        return this.nodeState;
    }

    public String getPath() {
        return this.path;
    }

    public long estimatedMemUsage() {
        return this.memUsage;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeStateEntry that = (NodeStateEntry)o;
        return Objects.equals(this.nodeState, that.nodeState) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return this.path;
    }

    public static class NodeStateEntryBuilder {
        private final NodeState nodeState;
        private final String path;
        private long memUsage;
        private long lastModified;
        private String id;

        public NodeStateEntryBuilder(NodeState nodeState, String path) {
            this.nodeState = nodeState;
            this.path = path;
        }

        public NodeStateEntryBuilder withMemUsage(long memUsage) {
            this.memUsage = memUsage;
            return this;
        }

        public NodeStateEntryBuilder withLastModified(long lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public NodeStateEntryBuilder withID(String id) {
            this.id = id;
            return this;
        }

        public NodeStateEntry build() {
            return new NodeStateEntry(this.nodeState, this.path, this.memUsage, this.lastModified, this.id);
        }
    }
}

