/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.jackrabbit.guava.common.base.Optional;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.AbstractIterator;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.guava.common.collect.PeekingIterator;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntry;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

class ChildNodeStateProvider {
    private final Iterable<NodeStateEntry> entries;
    private final String path;
    private final Set<String> preferredPathElements;

    public ChildNodeStateProvider(Iterable<NodeStateEntry> entries, String path, Set<String> preferredPathElements) {
        this.entries = entries;
        this.path = path;
        this.preferredPathElements = preferredPathElements;
    }

    public boolean hasChildNode(@NotNull String name) {
        return this.getChildNode(name).exists();
    }

    @NotNull
    public NodeState getChildNode(@NotNull String name) throws IllegalArgumentException {
        boolean isPreferred = this.preferredPathElements.contains(name);
        Optional o = Iterators.tryFind(this.children(isPreferred), p -> name.equals(ChildNodeStateProvider.name(p)));
        return o.isPresent() ? ((NodeStateEntry)o.get()).getNodeState() : EmptyNodeState.MISSING_NODE;
    }

    public long getChildNodeCount(long max) {
        if (max == 1L && this.children().hasNext()) {
            return 1L;
        }
        return Iterators.size(this.children());
    }

    public Iterable<String> getChildNodeNames() {
        return () -> Iterators.transform(this.children(), p -> ChildNodeStateProvider.name(p));
    }

    @NotNull
    public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
        return () -> Iterators.transform(this.children(), p -> new MemoryChildNodeEntry(ChildNodeStateProvider.name(p), p.getNodeState()));
    }

    Iterator<NodeStateEntry> children() {
        return this.children(false);
    }

    Iterator<NodeStateEntry> children(final boolean preferred) {
        final PeekingIterator pitr = Iterators.peekingIterator(this.entries.iterator());
        if (!pitr.hasNext()) {
            return Collections.emptyIterator();
        }
        while (pitr.hasNext() && !((NodeStateEntry)pitr.peek()).getPath().equals(this.path)) {
            pitr.next();
        }
        Preconditions.checkState((pitr.hasNext() && this.path.equals(((NodeStateEntry)pitr.next()).getPath()) ? 1 : 0) != 0, (String)"Did not found path [%s] in leftover iterator. Possibly node state accessed after main iterator has moved past it", (Object)this.path);
        return new AbstractIterator<NodeStateEntry>(){

            protected NodeStateEntry computeNext() {
                while (pitr.hasNext() && PathUtils.isAncestor((String)ChildNodeStateProvider.this.path, (String)((NodeStateEntry)pitr.peek()).getPath())) {
                    NodeStateEntry nextEntry = (NodeStateEntry)pitr.next();
                    String nextEntryPath = nextEntry.getPath();
                    if (!ChildNodeStateProvider.this.isImmediateChild(nextEntryPath)) continue;
                    String nextEntryName = PathUtils.getName((String)nextEntryPath);
                    if (preferred && !ChildNodeStateProvider.this.preferredPathElements.contains(nextEntryName)) {
                        return (NodeStateEntry)this.endOfData();
                    }
                    return nextEntry;
                }
                return (NodeStateEntry)this.endOfData();
            }
        };
    }

    private static String name(NodeStateEntry p) {
        return PathUtils.getName((String)p.getPath());
    }

    private boolean isImmediateChild(String childPath) {
        return PathUtils.getParentPath((String)childPath).equals(this.path);
    }
}

