/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile;

import com.mongodb.client.MongoDatabase;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.oak.commons.Compression;
import org.apache.jackrabbit.oak.index.IndexHelper;
import org.apache.jackrabbit.oak.index.IndexerSupport;
import org.apache.jackrabbit.oak.index.indexer.document.CompositeException;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntryTraverserFactory;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.DefaultMemoryManager;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.FlatFileSplitter;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.FlatFileStore;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.MemoryManager;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.MultithreadedTraverseWithSortStrategy;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateEntryReader;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateEntryWriter;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.StoreAndSortStrategy;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.TraverseWithSortStrategy;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.pipelined.PipelinedStrategy;
import org.apache.jackrabbit.oak.index.indexer.document.indexstore.IndexStoreSortStrategy;
import org.apache.jackrabbit.oak.index.indexer.document.indexstore.IndexStoreUtils;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.query.NodeStateNodeTypeInfoProvider;
import org.apache.jackrabbit.oak.query.ast.NodeTypeInfoProvider;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.filter.PathFilter;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlatFileNodeStoreBuilder {
    private static final String FLAT_FILE_STORE_DIR_NAME_PREFIX = "flat-fs-";
    public static final String OAK_INDEXER_TRAVERSE_WITH_SORT = "oak.indexer.traverseWithSortStrategy";
    public static final String OAK_INDEXER_SORT_STRATEGY_TYPE = "oak.indexer.sortStrategyType";
    public static final String OAK_INDEXER_SORTED_FILE_PATH = "oak.indexer.sortedFilePath";
    static final int DEFAULT_NUMBER_OF_DATA_DUMP_THREADS = 8;
    static final String PROP_THREAD_POOL_SIZE = "oak.indexer.dataDumpThreadPoolSize";
    static final int DEFAULT_NUMBER_OF_MERGE_TASK_THREADS = 1;
    static final String PROP_MERGE_THREAD_POOL_SIZE = "oak.indexer.mergeTaskThreadPoolSize";
    static final int DEFAULT_NUMBER_OF_FILES_PER_MERGE_TASK = 64;
    static final String PROP_MERGE_TASK_BATCH_SIZE = "oak.indexer.mergeTaskBatchSize";
    public static final String OAK_INDEXER_MAX_SORT_MEMORY_IN_GB = "oak.indexer.maxSortMemoryInGB";
    public static final int OAK_INDEXER_MAX_SORT_MEMORY_IN_GB_DEFAULT = 2;
    static final String OAK_INDEXER_DUMP_THRESHOLD_IN_MB = "oak.indexer.dumpThresholdInMB";
    static final int OAK_INDEXER_DUMP_THRESHOLD_IN_MB_DEFAULT = 16;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private List<Long> lastModifiedBreakPoints;
    private final File workDir;
    private final List<File> existingDataDumpDirs = new ArrayList<File>();
    private Set<String> preferredPathElements = Collections.emptySet();
    private BlobStore blobStore;
    private NodeStateEntryWriter entryWriter;
    private NodeStateEntryTraverserFactory nodeStateEntryTraverserFactory;
    private long entryCount = 0L;
    private File flatFileStoreDir;
    private final MemoryManager memoryManager;
    private long dumpThreshold = (long)Integer.getInteger("oak.indexer.dumpThresholdInMB", 16).intValue() * 0x100000L;
    private Predicate<String> pathPredicate = path -> true;
    private final Compression algorithm = IndexStoreUtils.compressionAlgorithm();
    private final boolean useTraverseWithSort = Boolean.parseBoolean(System.getProperty("oak.indexer.traverseWithSortStrategy", "false"));
    private final String sortStrategyTypeString = System.getProperty("oak.indexer.sortStrategyType");
    private final SortStrategyType sortStrategyType = this.sortStrategyTypeString != null ? SortStrategyType.valueOf(this.sortStrategyTypeString) : (this.useTraverseWithSort ? SortStrategyType.TRAVERSE_WITH_SORT : SortStrategyType.PIPELINED);
    private RevisionVector rootRevision = null;
    private DocumentNodeStore nodeStore = null;
    private MongoDocumentStore mongoDocumentStore = null;
    private MongoDatabase mongoDatabase = null;
    private Set<IndexDefinition> indexDefinitions = null;
    private String checkpoint;
    private StatisticsProvider statisticsProvider = StatisticsProvider.NOOP;

    public FlatFileNodeStoreBuilder(File workDir, MemoryManager memoryManager) {
        this.workDir = workDir;
        this.memoryManager = memoryManager;
    }

    public FlatFileNodeStoreBuilder(File workDir) {
        this.workDir = workDir;
        this.memoryManager = new DefaultMemoryManager();
    }

    public FlatFileNodeStoreBuilder withLastModifiedBreakPoints(List<Long> lastModifiedBreakPoints) {
        this.lastModifiedBreakPoints = lastModifiedBreakPoints;
        return this;
    }

    public FlatFileNodeStoreBuilder withBlobStore(BlobStore blobStore) {
        this.blobStore = blobStore;
        return this;
    }

    public FlatFileNodeStoreBuilder withDumpThreshold(long dumpThreshold) {
        this.dumpThreshold = dumpThreshold;
        return this;
    }

    public FlatFileNodeStoreBuilder withPreferredPathElements(Set<String> preferredPathElements) {
        this.preferredPathElements = preferredPathElements;
        return this;
    }

    public FlatFileNodeStoreBuilder addExistingDataDumpDir(File existingDataDumpDir) {
        if (existingDataDumpDir != null) {
            this.existingDataDumpDirs.add(existingDataDumpDir);
        }
        return this;
    }

    public FlatFileNodeStoreBuilder withNodeStateEntryTraverserFactory(NodeStateEntryTraverserFactory factory) {
        this.nodeStateEntryTraverserFactory = factory;
        return this;
    }

    public FlatFileNodeStoreBuilder withPathPredicate(Predicate<String> pathPredicate) {
        this.pathPredicate = pathPredicate;
        return this;
    }

    public FlatFileNodeStoreBuilder withIndexDefinitions(Set<IndexDefinition> indexDefinitions) {
        this.indexDefinitions = indexDefinitions;
        return this;
    }

    public FlatFileNodeStoreBuilder withRootRevision(RevisionVector rootRevision) {
        this.rootRevision = rootRevision;
        return this;
    }

    public FlatFileNodeStoreBuilder withNodeStore(DocumentNodeStore nodeStore) {
        this.nodeStore = nodeStore;
        return this;
    }

    public FlatFileNodeStoreBuilder withMongoDocumentStore(MongoDocumentStore mongoDocumentStore) {
        this.mongoDocumentStore = mongoDocumentStore;
        return this;
    }

    public FlatFileNodeStoreBuilder withCheckpoint(String checkpoint) {
        this.checkpoint = checkpoint;
        return this;
    }

    public FlatFileNodeStoreBuilder withMongoDatabase(MongoDatabase mongoDatabase) {
        this.mongoDatabase = mongoDatabase;
        return this;
    }

    public FlatFileNodeStoreBuilder withStatisticsProvider(StatisticsProvider statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
        return this;
    }

    public FlatFileStore build() throws IOException, CompositeException {
        this.logFlags();
        this.entryWriter = new NodeStateEntryWriter(this.blobStore);
        IndexStoreFiles indexStoreFiles = this.createdSortedStoreFiles();
        File metadataFile = indexStoreFiles.metadataFile;
        FlatFileStore store = new FlatFileStore(this.blobStore, indexStoreFiles.storeFiles.get(0), metadataFile, new NodeStateEntryReader(this.blobStore), Collections.unmodifiableSet(this.preferredPathElements), this.algorithm);
        if (this.entryCount > 0L) {
            store.setEntryCount(this.entryCount);
        }
        return store;
    }

    public List<FlatFileStore> buildList(IndexHelper indexHelper, IndexerSupport indexerSupport, Set<IndexDefinition> indexDefinitions) throws IOException, CompositeException {
        this.logFlags();
        this.entryWriter = new NodeStateEntryWriter(this.blobStore);
        IndexStoreFiles indexStoreFiles = this.createdSortedStoreFiles();
        List<File> fileList = indexStoreFiles.storeFiles;
        File metadataFile = indexStoreFiles.metadataFile;
        long start = System.currentTimeMillis();
        if (!fileList.stream().allMatch(FlatFileSplitter.IS_SPLIT)) {
            MemoryNodeStore nodeStore = new MemoryNodeStore(indexerSupport.retrieveNodeStateForCheckpoint());
            FlatFileSplitter splitter = new FlatFileSplitter(fileList.get(0), indexHelper.getWorkDir(), (NodeTypeInfoProvider)new NodeStateNodeTypeInfoProvider(nodeStore.getRoot()), new NodeStateEntryReader(this.blobStore), indexDefinitions);
            fileList = splitter.split();
            this.log.info("Split flat file to result files '{}' is done, took {} ms", fileList, (Object)(System.currentTimeMillis() - start));
        }
        ArrayList<FlatFileStore> storeList = new ArrayList<FlatFileStore>();
        for (File flatFileItem : fileList) {
            FlatFileStore store = new FlatFileStore(this.blobStore, flatFileItem, metadataFile, new NodeStateEntryReader(this.blobStore), Collections.unmodifiableSet(this.preferredPathElements), this.algorithm);
            storeList.add(store);
        }
        return storeList;
    }

    private IndexStoreFiles createdSortedStoreFiles() throws IOException, CompositeException {
        String sortedFilePath = System.getProperty(OAK_INDEXER_SORTED_FILE_PATH);
        if (StringUtils.isNotBlank((CharSequence)sortedFilePath)) {
            File sortedDir = new File(sortedFilePath);
            this.log.info("Attempting to read from provided sorted files directory [{}] (via system property '{}')", (Object)sortedDir.getAbsolutePath(), (Object)OAK_INDEXER_SORTED_FILE_PATH);
            IndexStoreFiles storeFiles = this.getIndexStoreFiles(sortedDir);
            if (storeFiles != null) {
                return storeFiles;
            }
        }
        this.createStoreDir();
        IndexStoreSortStrategy strategy = this.createSortStrategy(this.flatFileStoreDir);
        File result = strategy.createSortedStoreFile();
        File metadata = strategy.createMetadataFile();
        this.entryCount = strategy.getEntryCount();
        return new IndexStoreFiles(Collections.singletonList(result), metadata);
    }

    private IndexStoreFiles getIndexStoreFiles(File sortedDir) {
        if (sortedDir.exists() && sortedDir.canRead() && sortedDir.isDirectory()) {
            File[] storeFiles = sortedDir.listFiles((dir, name) -> name.endsWith(IndexStoreUtils.getSortedStoreFileName(this.algorithm)));
            File[] metadataFiles = sortedDir.listFiles((dir, name) -> name.endsWith(IndexStoreUtils.getMetadataFileName(this.algorithm)));
            if (storeFiles != null && storeFiles.length != 0) {
                if (metadataFiles == null || metadataFiles.length == 0) {
                    this.log.error("Unable to find metadata file in directory:{}", (Object)sortedDir.getAbsolutePath());
                    return new IndexStoreFiles(Arrays.asList(storeFiles), null);
                }
                Preconditions.checkState((metadataFiles.length == 1 ? 1 : 0) != 0, (String)"Multiple metadata files available at path:{}, metadataFiles:{}", (Object)sortedDir.getAbsolutePath(), Arrays.asList(metadataFiles));
                return new IndexStoreFiles(Arrays.asList(storeFiles), metadataFiles[0]);
            }
        } else {
            String msg = String.format("Cannot read sorted files directory at [%s]", sortedDir.getAbsolutePath());
            throw new IllegalArgumentException(msg);
        }
        return null;
    }

    IndexStoreSortStrategy createSortStrategy(File dir) throws IOException {
        switch (this.sortStrategyType) {
            case STORE_AND_SORT: {
                this.log.info("Using StoreAndSortStrategy.");
                this.log.warn("StoreAndSortStrategy is deprecated and will be removed in the near future. Use PipelinedStrategy instead.");
                return new StoreAndSortStrategy(this.nodeStateEntryTraverserFactory, this.preferredPathElements, this.entryWriter, dir, this.algorithm, this.pathPredicate, this.checkpoint);
            }
            case TRAVERSE_WITH_SORT: {
                this.log.info("Using TraverseWithSortStrategy");
                this.log.warn("TraverseWithSortStrategy is deprecated and will be removed in the near future. Use PipelinedStrategy instead.");
                return new TraverseWithSortStrategy(this.nodeStateEntryTraverserFactory, this.preferredPathElements, this.entryWriter, dir, this.algorithm, this.pathPredicate, this.checkpoint);
            }
            case MULTITHREADED_TRAVERSE_WITH_SORT: {
                this.log.info("Using MultithreadedTraverseWithSortStrategy");
                this.log.warn("MultithreadedTraverseWithSortStrategy is deprecated and will be removed in the near future. Use PipelinedStrategy instead.");
                return new MultithreadedTraverseWithSortStrategy(this.nodeStateEntryTraverserFactory, this.lastModifiedBreakPoints, this.preferredPathElements, this.blobStore, dir, this.existingDataDumpDirs, this.algorithm, this.memoryManager, this.dumpThreshold, this.pathPredicate, this.checkpoint);
            }
            case PIPELINED: {
                this.log.info("Using PipelinedStrategy");
                List<PathFilter> pathFilters = this.indexDefinitions.stream().map(IndexDefinition::getPathFilter).collect(Collectors.toList());
                return new PipelinedStrategy(this.mongoDocumentStore, this.mongoDatabase, this.nodeStore, this.rootRevision, this.preferredPathElements, this.blobStore, dir, this.algorithm, this.pathPredicate, pathFilters, this.checkpoint, this.statisticsProvider);
            }
        }
        throw new IllegalStateException("Not a valid sort strategy value " + this.sortStrategyType);
    }

    private void logFlags() {
        this.log.info("Preferred path elements are {}", (Object)Iterables.toString(this.preferredPathElements));
        this.log.info("Compression enabled while sorting : {} ({})", (Object)IndexStoreUtils.compressionEnabled(), (Object)"oak.indexer.useZip");
        this.log.info("LZ4 enabled for compression algorithm : {} ({})", (Object)IndexStoreUtils.useLZ4(), (Object)"oak.indexer.useLZ4");
        this.log.info("Sort strategy : {} ({})", (Object)this.sortStrategyType, (Object)OAK_INDEXER_TRAVERSE_WITH_SORT);
    }

    File createStoreDir() throws IOException {
        this.flatFileStoreDir = Files.createTempDirectory(this.workDir.toPath(), FLAT_FILE_STORE_DIR_NAME_PREFIX, new FileAttribute[0]).toFile();
        return this.flatFileStoreDir;
    }

    public File getFlatFileStoreDir() {
        return this.flatFileStoreDir;
    }

    private static class IndexStoreFiles {
        private final List<File> storeFiles;
        private final File metadataFile;

        public IndexStoreFiles(List<File> storeFiles, File metadataFile) {
            this.storeFiles = storeFiles;
            this.metadataFile = metadataFile;
        }
    }

    public static enum SortStrategyType {
        STORE_AND_SORT,
        TRAVERSE_WITH_SORT,
        MULTITHREADED_TRAVERSE_WITH_SORT,
        PIPELINED;

    }
}

