/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.io.LineIterator;
import org.apache.jackrabbit.guava.common.collect.AbstractIterator;
import org.apache.jackrabbit.guava.common.io.Closer;
import org.apache.jackrabbit.oak.commons.Compression;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntry;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.FlatFileStoreIterator;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.FlatFileStoreUtils;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateEntryReader;
import org.apache.jackrabbit.oak.index.indexer.document.indexstore.IndexStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;

public class FlatFileStore
implements IndexStore {
    private final Closer closer = Closer.create();
    private final BlobStore blobStore;
    private final File storeFile;
    private final File metadataFile;
    private final NodeStateEntryReader entryReader;
    private final Set<String> preferredPathElements;
    private final Compression algorithm;
    private long entryCount = -1L;
    private static final String STORE_TYPE = "FlatFileStore";

    public FlatFileStore(BlobStore blobStore, File storeFile, File metadataFile, NodeStateEntryReader entryReader, Set<String> preferredPathElements, Compression algorithm) {
        this.blobStore = blobStore;
        this.storeFile = storeFile;
        if (!(storeFile.exists() && storeFile.isFile() && storeFile.canRead())) {
            String msg = String.format("Cannot read store file at [%s]", storeFile.getAbsolutePath());
            throw new IllegalArgumentException(msg);
        }
        this.entryReader = entryReader;
        this.preferredPathElements = preferredPathElements;
        this.algorithm = algorithm;
        this.metadataFile = metadataFile;
    }

    public FlatFileStore(BlobStore blobStore, File storeFile, NodeStateEntryReader entryReader, Set<String> preferredPathElements, Compression algorithm) {
        this(blobStore, storeFile, null, entryReader, preferredPathElements, algorithm);
    }

    @Override
    public String getStorePath() {
        return this.storeFile.getParentFile().getAbsolutePath();
    }

    @Deprecated
    public String getFlatFileStorePath() {
        return this.storeFile.getParentFile().getAbsolutePath();
    }

    @Override
    public long getEntryCount() {
        return this.entryCount;
    }

    @Override
    public void setEntryCount(long entryCount) {
        this.entryCount = entryCount;
    }

    public String getMetadataFilePath() {
        return this.metadataFile != null ? this.metadataFile.getAbsolutePath() : null;
    }

    @Override
    public Iterator<NodeStateEntry> iterator() {
        String fileName = new File(this.storeFile.getParent(), this.storeFile.getName() + ".linkedList").getAbsolutePath();
        FlatFileStoreIterator it = new FlatFileStoreIterator(this.blobStore, fileName, this.createBaseIterator(), this.preferredPathElements);
        this.closer.register(it::close);
        return it;
    }

    private Iterator<NodeStateEntry> createBaseIterator() {
        final LineIterator itr = new LineIterator((Reader)FlatFileStoreUtils.createReader(this.storeFile, this.algorithm));
        this.closer.register(() -> ((LineIterator)itr).close());
        return new AbstractIterator<NodeStateEntry>(){

            protected NodeStateEntry computeNext() {
                if (itr.hasNext()) {
                    return FlatFileStore.this.convert(itr.nextLine());
                }
                LineIterator.closeQuietly((LineIterator)itr);
                return (NodeStateEntry)this.endOfData();
            }
        };
    }

    private NodeStateEntry convert(String line) {
        return this.entryReader.read(line);
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    @Override
    public String getIndexStoreType() {
        return STORE_TYPE;
    }

    @Override
    public boolean isIncremental() {
        return false;
    }
}

