/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile;

import java.io.Closeable;
import java.util.Iterator;
import java.util.Set;
import org.apache.jackrabbit.guava.common.collect.AbstractIterator;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntry;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.ChildNodeStateProvider;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.LazyChildrenNodeState;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateEntryReader;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateEntryWriter;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.linkedList.FlatFileBufferLinkedList;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.linkedList.NodeStateEntryList;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.linkedList.PersistedLinkedList;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FlatFileStoreIterator
extends AbstractIterator<NodeStateEntry>
implements Iterator<NodeStateEntry>,
Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Iterator<NodeStateEntry> baseItr;
    private final NodeStateEntryList buffer;
    private NodeStateEntry current;
    private final Set<String> preferredPathElements;
    private int maxBufferSize;
    static final String BUFFER_MEM_LIMIT_CONFIG_NAME = "oak.indexer.memLimitInMB";
    private static final int DEFAULT_BUFFER_MEM_LIMIT_IN_MB = 0;

    public FlatFileStoreIterator(BlobStore blobStore, String fileName, Iterator<NodeStateEntry> baseItr, Set<String> preferredPathElements) {
        this(blobStore, fileName, baseItr, preferredPathElements, Integer.getInteger(BUFFER_MEM_LIMIT_CONFIG_NAME, 0));
    }

    public FlatFileStoreIterator(BlobStore blobStore, String fileName, Iterator<NodeStateEntry> baseItr, Set<String> preferredPathElements, int memLimitConfig) {
        this.baseItr = baseItr;
        this.preferredPathElements = preferredPathElements;
        if (memLimitConfig == 0) {
            this.log.info("Using a key-value store buffer: {}", (Object)fileName);
            NodeStateEntryReader reader = new NodeStateEntryReader(blobStore);
            NodeStateEntryWriter writer = new NodeStateEntryWriter(blobStore);
            this.buffer = new PersistedLinkedList(fileName, writer, reader, 1000);
        } else if (memLimitConfig < 0) {
            this.log.info("Setting buffer memory limit unbounded");
            this.buffer = new FlatFileBufferLinkedList();
        } else {
            this.log.info("Setting buffer memory limit to {} MBs", (Object)memLimitConfig);
            this.buffer = new FlatFileBufferLinkedList((long)memLimitConfig * 1024L * 1024L);
        }
    }

    int getBufferSize() {
        return this.buffer.size();
    }

    long getBufferMemoryUsage() {
        return this.buffer.estimatedMemoryUsage();
    }

    protected NodeStateEntry computeNext() {
        this.current = this.computeNextEntry();
        if (this.current == null) {
            this.log.info("Max buffer size in complete traversal is [{}]", (Object)this.maxBufferSize);
            return (NodeStateEntry)this.endOfData();
        }
        return this.current;
    }

    private NodeStateEntry computeNextEntry() {
        if (this.buffer.size() > this.maxBufferSize) {
            this.maxBufferSize = this.buffer.size();
            this.log.info("Max buffer size changed {} (estimated memory usage: {} bytes) for path {}", new Object[]{this.maxBufferSize, this.buffer.estimatedMemoryUsage(), this.current.getPath()});
        }
        if (!this.buffer.isEmpty()) {
            NodeStateEntry e = this.buffer.remove();
            return this.wrapIfNeeded(e);
        }
        if (this.baseItr.hasNext()) {
            return this.wrap(this.baseItr.next());
        }
        return null;
    }

    private NodeStateEntry wrap(NodeStateEntry baseEntry) {
        LazyChildrenNodeState state = new LazyChildrenNodeState(baseEntry.getNodeState(), new ChildNodeStateProvider(this.getEntries(), baseEntry.getPath(), this.preferredPathElements));
        return new NodeStateEntry.NodeStateEntryBuilder(state, baseEntry.getPath()).withMemUsage(baseEntry.estimatedMemUsage()).build();
    }

    private Iterable<NodeStateEntry> getEntries() {
        return () -> Iterators.concat((Iterator)Iterators.singletonIterator((Object)this.current), this.queueIterator());
    }

    private Iterator<NodeStateEntry> queueIterator() {
        final Iterator<NodeStateEntry> qitr = this.buffer.iterator();
        return new AbstractIterator<NodeStateEntry>(){

            protected NodeStateEntry computeNext() {
                if (!qitr.hasNext() && FlatFileStoreIterator.this.baseItr.hasNext()) {
                    FlatFileStoreIterator.this.buffer.add(FlatFileStoreIterator.this.wrap(FlatFileStoreIterator.this.baseItr.next()));
                }
                if (qitr.hasNext()) {
                    return FlatFileStoreIterator.this.wrapIfNeeded((NodeStateEntry)qitr.next());
                }
                return (NodeStateEntry)this.endOfData();
            }
        };
    }

    private NodeStateEntry wrapIfNeeded(NodeStateEntry e) {
        if (this.buffer instanceof PersistedLinkedList) {
            return this.wrap(e);
        }
        return e;
    }

    @Override
    public void close() {
        this.buffer.close();
    }
}

