/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import org.apache.jackrabbit.oak.commons.Compression;

public class FlatFileStoreUtils {
    public static final String METADATA_SUFFIX = ".metadata";

    public static BufferedReader createReader(File file, boolean compressionEnabled) {
        return FlatFileStoreUtils.createReader(file, compressionEnabled ? Compression.GZIP : Compression.NONE);
    }

    public static BufferedReader createReader(File file, Compression algorithm) {
        try {
            FileInputStream in = new FileInputStream(file);
            return new BufferedReader(new InputStreamReader(algorithm.getInputStream((InputStream)in)));
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening file " + file, e);
        }
    }

    public static BufferedWriter createWriter(File file, boolean compressionEnabled) throws IOException {
        return FlatFileStoreUtils.createWriter(file, compressionEnabled ? Compression.GZIP : Compression.NONE);
    }

    public static BufferedWriter createWriter(File file, Compression algorithm) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        return new BufferedWriter(new OutputStreamWriter(algorithm.getOutputStream((OutputStream)out)));
    }

    public static long sizeOf(List<File> sortedFiles) {
        return sortedFiles.stream().mapToLong(File::length).sum();
    }

    public static String getSortedStoreFileName(boolean compressionEnabled) {
        return FlatFileStoreUtils.getSortedStoreFileName(compressionEnabled ? Compression.GZIP : Compression.NONE);
    }

    public static String getSortedStoreFileName(Compression algorithm) {
        return algorithm.addSuffix("store-sorted.json");
    }
}

