/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.ChildNodeStateProvider;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LazyChildrenNodeState
implements NodeState {
    private final NodeState delegate;
    private final ChildNodeStateProvider childProvider;

    public LazyChildrenNodeState(NodeState delegate, ChildNodeStateProvider childProvider) {
        this.delegate = delegate;
        this.childProvider = childProvider;
    }

    public boolean exists() {
        return this.delegate.exists();
    }

    public boolean hasProperty(@NotNull String name) {
        return this.delegate.hasProperty(name);
    }

    @Nullable
    public PropertyState getProperty(@NotNull String name) {
        return this.delegate.getProperty(name);
    }

    public boolean getBoolean(@NotNull String name) {
        return this.delegate.getBoolean(name);
    }

    public long getLong(String name) {
        return this.delegate.getLong(name);
    }

    @Nullable
    public String getString(String name) {
        return this.delegate.getString(name);
    }

    @NotNull
    public Iterable<String> getStrings(@NotNull String name) {
        return this.delegate.getStrings(name);
    }

    @Nullable
    public String getName(@NotNull String name) {
        return this.delegate.getName(name);
    }

    @NotNull
    public Iterable<String> getNames(@NotNull String name) {
        return this.delegate.getNames(name);
    }

    public long getPropertyCount() {
        return this.delegate.getPropertyCount();
    }

    @NotNull
    public Iterable<? extends PropertyState> getProperties() {
        return this.delegate.getProperties();
    }

    @NotNull
    public NodeBuilder builder() {
        return this.delegate.builder();
    }

    public boolean compareAgainstBaseState(NodeState base, NodeStateDiff diff) {
        return AbstractNodeState.compareAgainstBaseState((NodeState)this, (NodeState)base, (NodeStateDiff)diff);
    }

    public boolean hasChildNode(@NotNull String name) {
        return this.childProvider.hasChildNode(name);
    }

    @NotNull
    public NodeState getChildNode(@NotNull String name) throws IllegalArgumentException {
        return this.childProvider.getChildNode(name);
    }

    public long getChildNodeCount(long max) {
        return this.childProvider.getChildNodeCount(max);
    }

    public Iterable<String> getChildNodeNames() {
        return this.childProvider.getChildNodeNames();
    }

    @NotNull
    public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
        return this.childProvider.getChildNodeEntries();
    }
}

