/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile;

import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.SizeFileComparator;
import org.apache.jackrabbit.guava.common.base.Charsets;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.oak.commons.Compression;
import org.apache.jackrabbit.oak.commons.sort.ExternalSort;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.FlatFileStoreUtils;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateHolder;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.SimpleNodeStateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeRunner
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(MergeRunner.class);
    private final Charset charset = Charsets.UTF_8;
    private final Compression algorithm;
    private final ArrayList<File> mergedFiles = Lists.newArrayList();
    private final ArrayList<File> unmergedFiles = Lists.newArrayList();
    private ExecutorService executorService;
    private final int threadPoolSize;
    private final int batchMergeSize;
    private final Comparator<? super File> fileSizeComparator = new SizeFileComparator();
    private final File sortedFile;
    private final File mergeDir;
    private final Comparator<NodeStateHolder> comparator;
    private final BlockingQueue<File> sortedFiles;
    private final ConcurrentLinkedQueue<Throwable> throwables;
    private final Phaser phaser;
    public static final File MERGE_POISON_PILL = new File("");
    public static final File MERGE_FORCE_STOP_POISON_PILL = new File("merge-force-stop-poison-pill");
    private final AtomicBoolean mergeCancelled;

    MergeRunner(File sortedFile, BlockingQueue<File> sortedFiles, File mergeDir, Comparator<NodeStateHolder> comparator, Phaser phaser, int batchMergeSize, int threadPoolSize, Compression algorithm) {
        this.mergeDir = mergeDir;
        this.algorithm = algorithm;
        this.sortedFiles = sortedFiles;
        this.sortedFile = sortedFile;
        this.throwables = new ConcurrentLinkedQueue();
        this.comparator = comparator;
        this.phaser = phaser;
        this.batchMergeSize = batchMergeSize;
        this.threadPoolSize = threadPoolSize;
        this.mergeCancelled = new AtomicBoolean(false);
    }

    private boolean merge(List<File> files, File outputFile) {
        log.debug("performing merge for {} with size {} {}", new Object[]{outputFile.getName(), files.size(), files});
        try (BufferedWriter writer = FlatFileStoreUtils.createWriter(outputFile, this.algorithm);){
            Function<String, NodeStateHolder> func1 = line -> line == null ? null : new SimpleNodeStateHolder((String)line);
            Function<NodeStateHolder, String> func2 = holder -> holder == null ? null : holder.getLine();
            ExternalSort.mergeSortedFiles(files, (BufferedWriter)writer, this.comparator, (Charset)this.charset, (boolean)true, (Compression)this.algorithm, func2, func1);
        }
        catch (IOException e) {
            log.error("Merge failed with IOException", (Throwable)e);
            return false;
        }
        log.debug("merge complete for {} with {}", (Object)outputFile.getName(), files);
        return true;
    }

    private boolean finalMerge() {
        ArrayList<File> mergeTarget = new ArrayList<File>();
        int count = 0;
        while (!this.unmergedFiles.isEmpty()) {
            mergeTarget.clear();
            mergeTarget.addAll(this.getSmallestUnmergedFiles(this.batchMergeSize));
            this.markAsMerged(mergeTarget);
            File outputFile = new File(this.mergeDir, String.format("final-%s", ++count));
            if (this.unmergedFiles.isEmpty()) {
                outputFile = this.sortedFile;
            }
            log.info("running final batch merge task for {} with {}", (Object)outputFile.getName(), mergeTarget);
            if (!this.merge(mergeTarget, outputFile)) {
                return false;
            }
            if (outputFile.equals(this.sortedFile)) {
                return true;
            }
            this.unmergedFiles.add(outputFile);
        }
        return false;
    }

    private List<File> getSmallestUnmergedFiles(int size) {
        ArrayList<File> result = new ArrayList<File>(this.unmergedFiles);
        result.remove(MERGE_POISON_PILL);
        result.sort(this.fileSizeComparator);
        int endIdx = size > result.size() ? result.size() : size;
        return result.subList(0, endIdx);
    }

    private void markAsMerged(List<File> target) {
        this.mergedFiles.addAll(target);
        this.unmergedFiles.removeAll(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.executorService = Executors.newFixedThreadPool(this.threadPoolSize);
        try {
            FileUtils.forceMkdir((File)this.mergeDir);
        }
        catch (IOException e) {
            log.error("failed to create merged directory {}", (Object)this.mergeDir.getAbsolutePath());
        }
        Phaser mergeTaskPhaser = new Phaser(1);
        ArrayList results = Lists.newArrayList();
        int count = 0;
        block9: while (true) {
            try {
                while (true) {
                    File f = this.sortedFiles.take();
                    this.unmergedFiles.add(f);
                    log.debug("added sorted file {} to the unmerged list", (Object)f.getName());
                    if (f.equals(MERGE_POISON_PILL) || f.equals(MERGE_FORCE_STOP_POISON_PILL)) break block9;
                    if (this.unmergedFiles.size() < 2 * this.batchMergeSize) continue;
                    List<File> mergeTarget = this.getSmallestUnmergedFiles(this.batchMergeSize);
                    File intermediateMergeFile = new File(this.mergeDir, String.format("intermediate-%s", ++count));
                    Task mergeTask = new Task(mergeTarget, mergeTaskPhaser, intermediateMergeFile);
                    this.markAsMerged(mergeTarget);
                    results.add(this.executorService.submit(mergeTask));
                    log.info("created merge task for {} with {}", (Object)intermediateMergeFile.getName(), mergeTarget);
                }
            }
            catch (InterruptedException e) {
                log.error("Failed while draining from sortedFiles", (Throwable)e);
                continue;
            }
            break;
        }
        log.info("Waiting for batch sorting tasks completion");
        if (this.unmergedFiles.contains(MERGE_FORCE_STOP_POISON_PILL)) {
            log.info("Merger receives force stop signal, shutting down all merge tasks");
            this.mergeCancelled.set(true);
            mergeTaskPhaser.arriveAndAwaitAdvance();
            this.executorService.shutdown();
            mergeTaskPhaser.arrive();
            this.phaser.arriveAndDeregister();
            return;
        }
        mergeTaskPhaser.arriveAndAwaitAdvance();
        this.executorService.shutdown();
        this.sortedFiles.drainTo(this.unmergedFiles);
        this.unmergedFiles.remove(MERGE_POISON_PILL);
        log.info("There are still {} sorted files not merged yet", (Object)this.unmergedFiles.size());
        try {
            boolean exceptionsCaught = false;
            for (Future result : results) {
                try {
                    this.unmergedFiles.add((File)result.get());
                }
                catch (Throwable e) {
                    this.throwables.add(e);
                    exceptionsCaught = true;
                }
            }
            log.debug("Completed merge result collection {}. Arriving at phaser now.", (Object)(exceptionsCaught ? "partially" : "fully"));
        }
        finally {
            mergeTaskPhaser.arrive();
        }
        this.finalMerge();
        log.info("Total batch sorted files length is {}", (Object)this.mergedFiles.size());
        this.phaser.arriveAndDeregister();
    }

    private class Task
    implements Callable<File> {
        private final Phaser mergeTaskPhaser;
        private final List<File> mergeTarget;
        private final File mergedFile;

        Task(List<File> mergeTarget, Phaser mergeTaskPhaser, File mergedFile) {
            this.mergeTarget = mergeTarget;
            this.mergeTaskPhaser = mergeTaskPhaser;
            this.mergedFile = mergedFile;
            mergeTaskPhaser.register();
        }

        @Override
        public File call() throws Exception {
            block5: {
                try {
                    String mergedFileName = this.mergedFile.getName();
                    if (MergeRunner.this.mergeCancelled.get()) {
                        log.debug("merge cancelled, skipping merge task");
                        throw new EOFException("merge skipped for " + mergedFileName);
                    }
                    if (MergeRunner.this.merge(this.mergeTarget, this.mergedFile)) {
                        log.info("merge complete for {}", (Object)mergedFileName);
                        break block5;
                    }
                    log.error("merge failed for {}", (Object)mergedFileName);
                    throw new RuntimeException("merge failed for " + mergedFileName);
                }
                finally {
                    this.mergeTaskPhaser.arriveAndDeregister();
                }
            }
            return this.mergedFile;
        }
    }
}

