/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.jackrabbit.guava.common.base.Joiner;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopWriter;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntry;
import org.apache.jackrabbit.oak.json.BlobSerializer;
import org.apache.jackrabbit.oak.json.JsonSerializer;
import org.apache.jackrabbit.oak.plugins.blob.serializer.BlobIdSerializer;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class NodeStateEntryWriter {
    private static final boolean SORTED_PROPERTIES = Boolean.getBoolean("oak.NodeStateEntryWriter.sort");
    private static final String OAK_CHILD_ORDER = ":childOrder";
    public static final String DELIMITER = "|";
    private final JsopBuilder jw = new JsopBuilder();
    private final JsonSerializer serializer;
    private final Joiner pathJoiner = Joiner.on((char)'/');
    private final boolean includeChildOrder;

    public NodeStateEntryWriter(BlobStore blobStore) {
        this(blobStore, false);
    }

    public NodeStateEntryWriter(BlobStore blobStore, boolean includeChildOrder) {
        this.serializer = new JsonSerializer((JsopWriter)this.jw, (BlobSerializer)new BlobIdSerializer(blobStore));
        this.includeChildOrder = includeChildOrder;
    }

    public String toString(NodeStateEntry e) {
        return this.toString(e.getPath(), this.asJson(e.getNodeState()));
    }

    public String toString(String path, String nodeStateAsJson) {
        return path + DELIMITER + nodeStateAsJson;
    }

    public String toString(List<String> pathElements, String nodeStateAsJson) {
        int pathStringSize = pathElements.stream().mapToInt(String::length).sum();
        StringBuilder sb = new StringBuilder(nodeStateAsJson.length() + pathStringSize + pathElements.size() + 1);
        sb.append('/');
        this.pathJoiner.appendTo(sb, pathElements);
        sb.append(DELIMITER).append(nodeStateAsJson);
        return sb.toString();
    }

    public String asJson(NodeState nodeState) {
        if (SORTED_PROPERTIES) {
            return this.asSortedJson(nodeState);
        }
        return this.asJson(nodeState.getProperties());
    }

    String asSortedJson(NodeState nodeState) {
        ArrayList<PropertyState> properties = new ArrayList<PropertyState>();
        nodeState.getProperties().forEach(properties::add);
        properties.sort(Comparator.comparing(PropertyState::getName));
        return this.asJson(properties);
    }

    private String asJson(Iterable<? extends PropertyState> properties) {
        this.jw.resetWriter();
        this.jw.object();
        properties.forEach(ps -> {
            String name = ps.getName();
            if (this.include(name)) {
                this.jw.key(name);
                this.serializer.serialize(ps);
            }
        });
        this.jw.endObject();
        return this.jw.toString();
    }

    private boolean include(String propertyName) {
        return !OAK_CHILD_ORDER.equals(propertyName) || this.includeChildOrder;
    }

    public static String getPath(String entryLine) {
        return entryLine.substring(0, NodeStateEntryWriter.getDelimiterPosition(entryLine));
    }

    public static String[] getParts(String line) {
        int pos = NodeStateEntryWriter.getDelimiterPosition(line);
        return new String[]{line.substring(0, pos), line.substring(pos + 1)};
    }

    private static int getDelimiterPosition(String entryLine) {
        int indexOfPipe = entryLine.indexOf(DELIMITER);
        Preconditions.checkState((indexOfPipe > 0 ? 1 : 0) != 0, (String)"Invalid path entry [%s]", (Object)entryLine);
        return indexOfPipe;
    }
}

