/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Comparator;
import java.util.List;
import java.util.stream.StreamSupport;
import org.apache.jackrabbit.guava.common.collect.ImmutableList;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntry;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateEntryWriter;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFlatFileUtil {
    private static final Logger log = LoggerFactory.getLogger(SimpleFlatFileUtil.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final Writer writer;
    private final NodeStateEntryWriter entryWriter = new NodeStateEntryWriter(null, true);
    private long totalLines = 0L;

    private SimpleFlatFileUtil(Writer writer) {
        this.writer = writer;
    }

    public static void createFlatFileFor(NodeState ns, File f) throws IOException {
        log.info("createFlatFileFor : writing to {}", (Object)f.getCanonicalPath());
        try (BufferedWriter bw = Files.newBufferedWriter(f.toPath(), new OpenOption[0]);){
            SimpleFlatFileUtil.createFlatFileFor(ns, bw);
        }
    }

    public static void createFlatFileFor(NodeState ns, Writer writer) throws IOException {
        SimpleFlatFileUtil h = new SimpleFlatFileUtil(writer);
        h.addEntryAndTraverseChildren(ns);
        log.info("createFlatFileFor : done. wrote {} lines in total.", (Object)h.totalLines);
    }

    private void addEntryAndTraverseChildren(NodeState ns) throws IOException {
        this.addEntry(ns);
        StreamSupport.stream(ns.getChildNodeEntries().spliterator(), false).sorted(Comparator.comparing(ChildNodeEntry::getName)).forEach(e -> {
            try {
                this.addEntryAndTraverseChildren(e.getNodeState());
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
        });
    }

    private void addEntry(NodeState ns) throws IOException {
        DocumentNodeState dns = (DocumentNodeState)ns;
        NodeStateEntry e = new NodeStateEntry.NodeStateEntryBuilder((NodeState)dns, dns.getPath().toString()).build();
        String path = e.getPath();
        if (NodeStateUtils.isHiddenPath((String)path)) {
            return;
        }
        String jsonText = this.entryWriter.asSortedJson(e.getNodeState());
        String line = this.entryWriter.toString((List<String>)ImmutableList.copyOf((Iterable)PathUtils.elements((String)path)), jsonText);
        this.writer.append(line);
        this.writer.append(LINE_SEPARATOR);
        ++this.totalLines;
        if (this.totalLines % 10000L == 0L) {
            log.info("addEntry : wrote {} lines so far.", (Object)this.totalLines);
        }
    }
}

