/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile;

import java.util.List;
import org.apache.jackrabbit.guava.common.base.Charsets;
import org.apache.jackrabbit.guava.common.collect.ImmutableList;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateHolder;

class StateInBytesHolder
implements NodeStateHolder {
    private final List<String> pathElements;
    private final byte[] content;

    public StateInBytesHolder(String path, String line) {
        this.pathElements = ImmutableList.copyOf((Iterable)PathUtils.elements((String)path));
        this.content = line.getBytes(Charsets.UTF_8);
    }

    @Override
    public List<String> getPathElements() {
        return this.pathElements;
    }

    @Override
    public String getLine() {
        return new String(this.content, Charsets.UTF_8);
    }

    @Override
    public int getMemorySize() {
        int memoryUsed = 0;
        for (String e : this.pathElements) {
            memoryUsed += StringUtils.estimateMemoryUsage((String)e);
        }
        return memoryUsed += this.content.length;
    }
}

