/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.guava.common.base.StandardSystemProperty;
import org.apache.jackrabbit.guava.common.base.Stopwatch;
import org.apache.jackrabbit.oak.commons.Compression;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.index.indexer.document.LastModifiedRange;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntry;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntryTraverser;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntryTraverserFactory;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateEntrySorter;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateEntryWriter;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.PathElementComparator;
import org.apache.jackrabbit.oak.index.indexer.document.indexstore.IndexStoreSortStrategyBase;
import org.apache.jackrabbit.oak.index.indexer.document.indexstore.IndexStoreUtils;
import org.apache.jackrabbit.oak.plugins.document.mongo.TraversingRange;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
class StoreAndSortStrategy
extends IndexStoreSortStrategyBase {
    private static final String OAK_INDEXER_DELETE_ORIGINAL = "oak.indexer.deleteOriginal";
    private static final int LINE_SEP_LENGTH = StandardSystemProperty.LINE_SEPARATOR.value().length();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final NodeStateEntryTraverserFactory nodeStatesFactory;
    private final PathElementComparator comparator;
    private final NodeStateEntryWriter entryWriter;
    private long entryCount;
    private final boolean deleteOriginal = Boolean.parseBoolean(System.getProperty("oak.indexer.deleteOriginal", "true"));
    private final int maxMemory = Integer.getInteger("oak.indexer.maxSortMemoryInGB", 2);
    private long textSize;

    public StoreAndSortStrategy(NodeStateEntryTraverserFactory nodeStatesFactory, Set<String> preferredPaths, NodeStateEntryWriter entryWriter, File storeDir, Compression algorithm, Predicate<String> pathPredicate, String checkpoint) {
        super(storeDir, algorithm, pathPredicate, preferredPaths, checkpoint);
        this.nodeStatesFactory = nodeStatesFactory;
        this.comparator = new PathElementComparator(preferredPaths);
        this.entryWriter = entryWriter;
    }

    @Deprecated
    public StoreAndSortStrategy(NodeStateEntryTraverserFactory nodeStatesFactory, PathElementComparator comparator, NodeStateEntryWriter entryWriter, File storeDir, Compression algorithm, Predicate<String> pathPredicate) {
        super(storeDir, algorithm, pathPredicate, null, null);
        this.nodeStatesFactory = nodeStatesFactory;
        this.comparator = comparator;
        this.entryWriter = entryWriter;
    }

    @Override
    public File createSortedStoreFile() throws IOException {
        try (NodeStateEntryTraverser nodeStates = this.nodeStatesFactory.create(new TraversingRange(new LastModifiedRange(0L, Long.MAX_VALUE), null));){
            File storeFile = this.writeToStore(nodeStates, this.getStoreDir(), IndexStoreUtils.getSortedStoreFileName(this.getAlgorithm()));
            File file = this.sortStoreFile(storeFile);
            return file;
        }
    }

    @Override
    public long getEntryCount() {
        return this.entryCount;
    }

    private File sortStoreFile(File storeFile) throws IOException {
        File sortWorkDir = new File(storeFile.getParent(), "sort-work-dir");
        FileUtils.forceMkdir((File)sortWorkDir);
        File sortedFile = new File(storeFile.getParentFile(), IndexStoreUtils.getSortedStoreFileName(this.getAlgorithm()));
        NodeStateEntrySorter sorter = new NodeStateEntrySorter(this.comparator, storeFile, sortWorkDir, sortedFile);
        this.logFlags();
        sorter.setCompressionAlgorithm(this.getAlgorithm());
        sorter.setMaxMemoryInGB(this.maxMemory);
        sorter.setDeleteOriginal(this.deleteOriginal);
        sorter.setActualFileSize(this.textSize);
        sorter.sort();
        return sorter.getSortedFile();
    }

    private File writeToStore(NodeStateEntryTraverser nodeStates, File dir, String fileName) throws IOException {
        this.entryCount = 0L;
        File file = new File(dir, fileName);
        Stopwatch sw = Stopwatch.createStarted();
        try (BufferedWriter w = IndexStoreUtils.createWriter(file, this.getAlgorithm());){
            for (NodeStateEntry e : nodeStates) {
                String path = e.getPath();
                if (NodeStateUtils.isHiddenPath((String)path) || !this.getPathPredicate().test(path)) continue;
                String line = this.entryWriter.toString(e);
                w.append(line);
                w.newLine();
                this.textSize += (long)(line.length() + LINE_SEP_LENGTH);
                ++this.entryCount;
            }
        }
        String sizeStr = !this.getAlgorithm().equals(Compression.NONE) ? String.format("compressed/%s actual size", IOUtils.humanReadableByteCount((long)this.textSize)) : "";
        this.log.info("Dumped {} nodestates in json format in {} ({} {})", new Object[]{this.entryCount, sw, IOUtils.humanReadableByteCount((long)file.length()), sizeStr});
        return file;
    }

    private void logFlags() {
        this.log.info("Delete original dump from traversal : {} ({})", (Object)this.deleteOriginal, (Object)OAK_INDEXER_DELETE_ORIGINAL);
        this.log.info("Max heap memory (GB) to be used for merge sort : {} ({})", (Object)this.maxMemory, (Object)"oak.indexer.maxSortMemoryInGB");
    }
}

