/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile.linkedList;

import java.util.Iterator;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.index.indexer.document.NodeStateEntry;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.linkedList.NodeStateEntryList;
import org.jetbrains.annotations.NotNull;

public class FlatFileBufferLinkedList
implements NodeStateEntryList {
    private ListNode head;
    private ListNode tail;
    private int size;
    private long memUsage;
    private final long memLimit;

    public FlatFileBufferLinkedList() {
        this(Long.MAX_VALUE);
    }

    public FlatFileBufferLinkedList(long memLimit) {
        this.tail = this.head = new ListNode();
        this.size = 0;
        this.memUsage = 0L;
        this.memLimit = memLimit;
    }

    @Override
    public void add(@NotNull NodeStateEntry item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"Can't add null to the list");
        long incomingSize = item.estimatedMemUsage();
        long memUsage = this.estimatedMemoryUsage();
        Preconditions.checkState((memUsage + incomingSize <= this.memLimit ? 1 : 0) != 0, (Object)String.format("Adding item (%s) estimated with %s bytes would increase mem usage beyond upper limit (%s). Current estimated mem usage is %s bytes", item.getPath(), incomingSize, this.memLimit, memUsage));
        this.tail = this.tail.next = new ListNode(item);
        ++this.size;
        this.memUsage += incomingSize;
    }

    @Override
    public NodeStateEntry remove() {
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (Object)"Cannot remove item from empty list");
        NodeStateEntry ret = this.head.next.data;
        this.head.next.isValid = false;
        this.head.next = this.head.next.next;
        --this.size;
        this.memUsage -= ret.estimatedMemUsage();
        if (this.size == 0) {
            this.tail = this.head;
        }
        return ret;
    }

    @Override
    public Iterator<NodeStateEntry> iterator() {
        return NodeIterator.iteratorFor(this.head);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public long estimatedMemoryUsage() {
        return this.memUsage;
    }

    @Override
    public void close() {
    }

    static class NodeIterator
    implements Iterator<NodeStateEntry> {
        private ListNode current;

        static NodeIterator iteratorFor(@NotNull ListNode node) {
            Preconditions.checkNotNull((Object)node);
            return new NodeIterator(node);
        }

        NodeIterator(@NotNull ListNode start) {
            Preconditions.checkNotNull((Object)start);
            this.current = start;
        }

        @Override
        public boolean hasNext() {
            return this.current.next != null;
        }

        @Override
        public NodeStateEntry next() {
            Preconditions.checkState((boolean)this.hasNext(), (Object)"No next");
            this.current = this.current.next;
            Preconditions.checkState((boolean)this.current.isValid, (Object)"Can't call next from a removed node");
            return this.current.data;
        }
    }

    static class ListNode {
        private ListNode next;
        private final NodeStateEntry data;
        private boolean isValid = true;

        private ListNode() {
            this.data = null;
            this.next = null;
        }

        ListNode(@NotNull NodeStateEntry data) {
            Preconditions.checkNotNull((Object)data);
            this.data = data;
            this.next = null;
        }
    }
}

