/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile.pipelined;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.pipelined.PipelinedStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundedHistogram {
    private static final Logger LOG = LoggerFactory.getLogger(PipelinedStrategy.class);
    private final ConcurrentHashMap<String, LongAdder> histogram = new ConcurrentHashMap();
    private volatile boolean overflowed = false;
    private final String histogramName;
    private final int maxHistogramSize;

    public BoundedHistogram(String name, int maxHistogramSize) {
        this.histogramName = name;
        this.maxHistogramSize = maxHistogramSize;
    }

    public void addEntry(String key) {
        if (!this.overflowed && this.histogram.size() >= this.maxHistogramSize) {
            this.overflowed = true;
            LOG.warn("{} histogram overflowed (Max entries: {}). No more entries will be added, current entries will still be updated.", (Object)this.histogramName, (Object)this.maxHistogramSize);
        }
        if (this.overflowed) {
            LongAdder counter = this.histogram.get(key);
            if (counter != null) {
                counter.increment();
            }
        } else {
            this.histogram.computeIfAbsent(key, k -> new LongAdder()).increment();
        }
    }

    public boolean isOverflowed() {
        return this.overflowed;
    }

    public ConcurrentHashMap<String, LongAdder> getMap() {
        return this.histogram;
    }

    public String prettyPrint() {
        return this.prettyPrintTopEntries(20);
    }

    public String prettyPrintTopEntries(int numEntries) {
        String str = this.histogram.entrySet().stream().map(e -> Map.entry((String)e.getKey(), ((LongAdder)e.getValue()).sum())).sorted((e1, e2) -> Long.compare((Long)e2.getValue(), (Long)e1.getValue())).limit(numEntries).map(e -> "\"" + (String)e.getKey() + "\":" + e.getValue()).collect(Collectors.joining(", ", "{", "}"));
        if (this.overflowed) {
            return str + ". Histogram overflowed (max buckets " + this.maxHistogramSize + ") some buckets may be missing";
        }
        return str;
    }
}

