/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile.pipelined;

import org.bson.BsonDocument;

final class DownloadRange {
    private final long lastModifiedFrom;
    private final long lastModifiedTo;
    private final String startAfterDocumentID;

    public DownloadRange(long lastModifiedFrom, long lastModifiedTo, String startAfterDocumentID) {
        if (lastModifiedTo < lastModifiedFrom) {
            throw new IllegalArgumentException("Invalid range (" + lastModifiedFrom + ", " + lastModifiedTo + ")");
        }
        this.lastModifiedFrom = lastModifiedFrom;
        this.lastModifiedTo = lastModifiedTo;
        this.startAfterDocumentID = startAfterDocumentID;
    }

    public String getStartAfterDocumentID() {
        return this.startAfterDocumentID;
    }

    public long getLastModifiedFrom() {
        return this.lastModifiedFrom;
    }

    public long getLastModifiedTo() {
        return this.lastModifiedTo;
    }

    public BsonDocument getFindQuery() {
        String lastModifiedRangeQueryPart = "{$gte:" + this.lastModifiedFrom;
        lastModifiedRangeQueryPart = this.lastModifiedTo == Long.MAX_VALUE ? lastModifiedRangeQueryPart + "}" : lastModifiedRangeQueryPart + ", $lt:" + this.lastModifiedTo + "}";
        Object idRangeQueryPart = "";
        if (this.startAfterDocumentID != null) {
            String condition = "{$gt:\"" + this.startAfterDocumentID + "\"}";
            idRangeQueryPart = ", _id:" + condition;
        }
        return BsonDocument.parse((String)("{_modified:" + lastModifiedRangeQueryPart + (String)idRangeQueryPart + "}"));
    }

    public String toString() {
        return "DownloadRange{lastModifiedFrom=" + this.lastModifiedFrom + ", lastModifiedTo=" + this.lastModifiedTo + ", startAfterDocumentID='" + this.startAfterDocumentID + "'}";
    }
}

