/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile.pipelined;

import java.util.Map;
import java.util.TreeMap;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.StableRevisionComparator;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.BsonTypeClassMap;
import org.bson.codecs.BsonTypeCodecMap;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

public class NodeDocumentCodec
implements Codec<NodeDocument> {
    public static final String SIZE_FIELD = "__ESTIMATED_SIZE__";
    private final MongoDocumentStore store;
    private final Collection<NodeDocument> collection;
    private final BsonTypeCodecMap bsonTypeCodecMap;
    private final DecoderContext decoderContext = DecoderContext.builder().build();
    private final Codec<String> stringCoded;
    private final Codec<Long> longCoded;
    private final Codec<Boolean> booleanCoded;
    private int estimatedSizeOfCurrentObject = 0;

    public NodeDocumentCodec(MongoDocumentStore store, Collection<NodeDocument> collection, CodecRegistry defaultRegistry) {
        this.store = store;
        this.collection = collection;
        this.bsonTypeCodecMap = new BsonTypeCodecMap(new BsonTypeClassMap(), defaultRegistry);
        this.stringCoded = this.bsonTypeCodecMap.get(BsonType.STRING);
        this.longCoded = this.bsonTypeCodecMap.get(BsonType.INT64);
        this.booleanCoded = this.bsonTypeCodecMap.get(BsonType.BOOLEAN);
    }

    public NodeDocument decode(BsonReader reader, DecoderContext decoderContext) {
        NodeDocument nodeDocument = (NodeDocument)this.collection.newDocument((DocumentStore)this.store);
        this.estimatedSizeOfCurrentObject = 0;
        reader.readStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName = reader.readName();
            Object value = this.readValue(reader, fieldName);
            nodeDocument.put(fieldName, value);
        }
        reader.readEndDocument();
        nodeDocument.put(SIZE_FIELD, (Object)this.estimatedSizeOfCurrentObject);
        return nodeDocument;
    }

    public void encode(BsonWriter writer, NodeDocument value, EncoderContext encoderContext) {
        throw new UnsupportedOperationException("encode");
    }

    public Class<NodeDocument> getEncoderClass() {
        return NodeDocument.class;
    }

    private Object readValue(BsonReader reader, String fieldName) {
        Object value;
        int valSize;
        this.estimatedSizeOfCurrentObject += 16 + fieldName.length();
        BsonType bsonType = reader.getCurrentBsonType();
        switch (bsonType) {
            case STRING: {
                String sValue = (String)this.stringCoded.decode(reader, this.decoderContext);
                valSize = 16 + sValue.length() * 2;
                value = sValue;
                break;
            }
            case INT64: {
                value = this.longCoded.decode(reader, this.decoderContext);
                valSize = 16;
                break;
            }
            case DOCUMENT: {
                value = this.readDocument(reader);
                valSize = 0;
                break;
            }
            case BOOLEAN: {
                value = this.booleanCoded.decode(reader, this.decoderContext);
                valSize = 16;
                break;
            }
            case NULL: {
                reader.readNull();
                value = null;
                valSize = 0;
                break;
            }
            case ARRAY: {
                throw new UnsupportedOperationException("ARRAY");
            }
            case JAVASCRIPT_WITH_SCOPE: {
                throw new UnsupportedOperationException("JAVASCRIPT_WITH_SCOPE");
            }
            case DB_POINTER: {
                throw new UnsupportedOperationException("DB_POINTER");
            }
            case BINARY: {
                throw new UnsupportedOperationException("BINARY");
            }
            default: {
                value = this.bsonTypeCodecMap.get(bsonType).decode(reader, this.decoderContext);
                valSize = 16;
                if (!(value instanceof Number) || !"_modified".equals(fieldName) && !"_modCount".equals(fieldName)) break;
                value = Utils.asLong((Number)((Number)value));
            }
        }
        this.estimatedSizeOfCurrentObject += valSize;
        return value;
    }

    private Map<Revision, Object> readDocument(BsonReader reader) {
        TreeMap<Revision, Object> map = new TreeMap<Revision, Object>(StableRevisionComparator.REVERSE);
        reader.readStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName = reader.readName();
            Object value = this.readValue(reader, fieldName);
            map.put(Revision.fromString((String)fieldName), value);
        }
        reader.readEndDocument();
        return map;
    }
}

