/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile.pipelined;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class NodeStateEntryBatch {
    static final int MIN_BUFFER_SIZE = 262144;
    private final ByteBuffer buffer;
    private final int maxEntries;
    private int numberOfEntries = 0;
    private int sizeOfEntriesBytes = 0;

    public static NodeStateEntryBatch createNodeStateEntryBatch(int bufferSizeBytes, int maxNumEntries) {
        if (bufferSizeBytes < 262144) {
            throw new IllegalArgumentException("Buffer size must be at least 262144 bytes");
        }
        if (maxNumEntries < 1) {
            throw new IllegalArgumentException("Max number of entries must be at least 1");
        }
        ByteBuffer buffer = ByteBuffer.allocate(bufferSizeBytes);
        return new NodeStateEntryBatch(buffer, maxNumEntries);
    }

    public NodeStateEntryBatch(ByteBuffer buffer, int maxEntries) {
        this.buffer = buffer;
        this.maxEntries = maxEntries;
    }

    public int addEntry(String path, byte[] entryData) throws BufferFullException {
        if (this.numberOfEntries == this.maxEntries) {
            throw new BufferFullException("Sort buffer size is full, reached max entries: " + this.numberOfEntries);
        }
        int bufferPos = this.buffer.position();
        byte[] pathBytes = path.getBytes(StandardCharsets.UTF_8);
        int totalSize = 4 + pathBytes.length + 4 + entryData.length;
        try {
            this.buffer.putInt(pathBytes.length);
            this.buffer.put(pathBytes);
            this.buffer.putInt(entryData.length);
            this.buffer.put(entryData);
            ++this.numberOfEntries;
            this.sizeOfEntriesBytes += totalSize;
            return totalSize;
        }
        catch (BufferOverflowException e) {
            this.buffer.position(bufferPos);
            throw new BufferFullException("while adding entry " + path + " of size: " + totalSize, e);
        }
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public boolean isAtMaxEntries() {
        if (this.numberOfEntries > this.maxEntries) {
            throw new AssertionError((Object)("Sort buffer size exceeded max entries: " + this.numberOfEntries + " > " + this.maxEntries));
        }
        return this.numberOfEntries == this.maxEntries;
    }

    public void flip() {
        this.buffer.flip();
    }

    public void reset() {
        this.buffer.clear();
        this.numberOfEntries = 0;
        this.sizeOfEntriesBytes = 0;
    }

    public int sizeOfEntriesBytes() {
        return this.sizeOfEntriesBytes;
    }

    public int numberOfEntries() {
        return this.numberOfEntries;
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public static class BufferFullException
    extends RuntimeException {
        public BufferFullException(String message) {
            super(message);
        }

        public BufferFullException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

