/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile.pipelined;

import java.util.ArrayList;
import java.util.function.Function;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.pipelined.NodeStateHolder;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.pipelined.PipelinedStrategy;

final class NodeStateHolderFactory
implements Function<byte[], NodeStateHolder> {
    private static final byte PIPE = 124;
    private static final byte PATH_SEPARATOR = 47;
    private final ArrayList<String> partsBuffer = new ArrayList(16);

    NodeStateHolderFactory() {
    }

    private static int indexOf(byte[] ffsLine, byte ch, int from, int to) {
        for (int i = from; i < to; ++i) {
            if (ffsLine[i] != ch) continue;
            return i;
        }
        return -1;
    }

    private static int indexOf(byte[] ffsLine, byte ch) {
        return NodeStateHolderFactory.indexOf(ffsLine, ch, 0, ffsLine.length);
    }

    private static boolean isAbsolutePath(String path) {
        return !path.isEmpty() && path.charAt(0) == '/';
    }

    @Override
    public NodeStateHolder apply(byte[] ffsLine) {
        return ffsLine == null ? null : new NodeStateHolder(ffsLine, this.parts(ffsLine));
    }

    private String[] parts(byte[] ffsLine) {
        int pos;
        this.partsBuffer.clear();
        int pipeIdx = NodeStateHolderFactory.indexOf(ffsLine, (byte)124);
        if (pipeIdx < 0) {
            throw new IllegalStateException("Line does not contain a pipe: " + new String(ffsLine, PipelinedStrategy.FLATFILESTORE_CHARSET));
        }
        String path = new String(ffsLine, 0, pipeIdx, PipelinedStrategy.FLATFILESTORE_CHARSET);
        int n = pos = NodeStateHolderFactory.isAbsolutePath(path) ? 1 : 0;
        while (pos < path.length()) {
            int i = path.indexOf(47, pos);
            if (i < 0) {
                this.partsBuffer.add(path.substring(pos));
                pos = path.length();
                continue;
            }
            this.partsBuffer.add(path.substring(pos, i));
            pos = i + 1;
        }
        return this.partsBuffer.toArray(new String[0]);
    }
}

