/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile.pipelined;

import java.util.Comparator;
import java.util.Set;

public class PathElementComparator
implements Comparator<String[]> {
    private final Set<String> preferred;

    public PathElementComparator(Set<String> preferredPathElements) {
        this.preferred = Set.copyOf(preferredPathElements);
    }

    @Override
    public int compare(String[] p1, String[] p2) {
        int i1 = 0;
        for (int i2 = 0; i1 < p1.length || i2 < p2.length; ++i1, ++i2) {
            if (i1 >= p1.length) {
                return -1;
            }
            if (i2 >= p2.length) {
                return 1;
            }
            String pe1 = p1[i1];
            String pe2 = p2[i2];
            boolean pe1Preferred = this.preferred.contains(pe1);
            boolean pe2Preferred = this.preferred.contains(pe2);
            if (pe1Preferred && !pe2Preferred) {
                return -1;
            }
            if (!pe2Preferred || pe1Preferred) continue;
            return 1;
        }
        return 0;
    }
}

