/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile.pipelined;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.guava.common.base.Stopwatch;
import org.apache.jackrabbit.oak.commons.Compression;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.pipelined.NodeStateEntryBatch;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.pipelined.PathElementComparator;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.pipelined.PipelinedStrategy;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.pipelined.PipelinedUtils;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.pipelined.SortKey;
import org.apache.jackrabbit.oak.index.indexer.document.indexstore.IndexStoreUtils;
import org.apache.jackrabbit.oak.plugins.index.MetricsFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PipelinedSortBatchTask
implements Callable<Result> {
    private static final Logger LOG = LoggerFactory.getLogger(PipelinedSortBatchTask.class);
    private static final String THREAD_NAME = "mongo-sort-batch";
    private final Comparator<SortKey> pathComparator;
    private final Compression algorithm;
    private final BlockingQueue<NodeStateEntryBatch> emptyBuffersQueue;
    private final BlockingQueue<NodeStateEntryBatch> nonEmptyBuffersQueue;
    private final BlockingQueue<Path> sortedFilesQueue;
    private final Path sortWorkDir;
    private final ArrayList<SortKey> sortBuffer = new ArrayList(32768);
    private long entriesProcessed = 0L;
    private long batchesProcessed = 0L;
    private long timeCreatingSortArrayMillis = 0L;
    private long timeSortingMillis = 0L;
    private long timeWritingMillis = 0L;

    public PipelinedSortBatchTask(Path storeDir, PathElementComparator pathComparator, Compression algorithm, BlockingQueue<NodeStateEntryBatch> emptyBuffersQueue, BlockingQueue<NodeStateEntryBatch> nonEmptyBuffersQueue, BlockingQueue<Path> sortedFilesQueue) throws IOException {
        this.pathComparator = (e1, e2) -> pathComparator.compare(e1.getPathElements(), e2.getPathElements());
        this.algorithm = algorithm;
        this.emptyBuffersQueue = emptyBuffersQueue;
        this.nonEmptyBuffersQueue = nonEmptyBuffersQueue;
        this.sortedFilesQueue = sortedFilesQueue;
        this.sortWorkDir = PipelinedSortBatchTask.createdSortWorkDir(storeDir);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result call() throws Exception {
        Stopwatch taskStartTime = Stopwatch.createStarted();
        String originalName = Thread.currentThread().getName();
        Thread.currentThread().setName(THREAD_NAME);
        try {
            LOG.info("[TASK:{}:START] Starting sort-and-save task", (Object)THREAD_NAME.toUpperCase(Locale.ROOT));
            while (true) {
                LOG.info("Waiting for next batch");
                NodeStateEntryBatch nseBuffer = this.nonEmptyBuffersQueue.take();
                if (nseBuffer == PipelinedStrategy.SENTINEL_NSE_BUFFER) {
                    long totalTimeMillis = taskStartTime.elapsed().toMillis();
                    this.sortBuffer.clear();
                    this.sortBuffer.trimToSize();
                    String timeCreatingSortArrayPercentage = PipelinedUtils.formatAsPercentage(this.timeCreatingSortArrayMillis, totalTimeMillis);
                    String timeSortingPercentage = PipelinedUtils.formatAsPercentage(this.timeSortingMillis, totalTimeMillis);
                    String timeWritingPercentage = PipelinedUtils.formatAsPercentage(this.timeWritingMillis, totalTimeMillis);
                    String metrics = MetricsFormatter.newBuilder().add("batchesProcessed", this.batchesProcessed).add("entriesProcessed", this.entriesProcessed).add("timeCreatingSortArrayMillis", this.timeCreatingSortArrayMillis).add("timeCreatingSortArrayPercentage", timeCreatingSortArrayPercentage).add("timeSortingMillis", this.timeSortingMillis).add("timeSortingPercentage", timeSortingPercentage).add("timeWritingMillis", this.timeWritingMillis).add("timeWritingPercentage", timeWritingPercentage).add("totalTimeSeconds", totalTimeMillis / 1000L).build();
                    LOG.info("[TASK:{}:END] Metrics: {}", (Object)THREAD_NAME.toUpperCase(Locale.ROOT), (Object)metrics);
                    Result result = new Result(this.entriesProcessed);
                    return result;
                }
                this.sortAndSaveBatch(nseBuffer);
                nseBuffer.reset();
                this.emptyBuffersQueue.put(nseBuffer);
                continue;
                break;
            }
        }
        catch (InterruptedException t) {
            LOG.warn("Thread interrupted", (Throwable)t);
            throw t;
        }
        catch (Throwable t) {
            LOG.warn("Thread terminating with exception", t);
            throw t;
        }
        finally {
            Thread.currentThread().setName(originalName);
        }
    }

    private void buildSortArray(NodeStateEntryBatch nseb) {
        Stopwatch startTime = Stopwatch.createStarted();
        ByteBuffer buffer = nseb.getBuffer();
        int totalPathSize = 0;
        while (buffer.hasRemaining()) {
            int positionInBuffer = buffer.position();
            int pathLength = buffer.getInt();
            totalPathSize += pathLength;
            String path = new String(buffer.array(), buffer.position(), pathLength, StandardCharsets.UTF_8);
            buffer.position(buffer.position() + pathLength);
            int entryLength = buffer.getInt();
            buffer.position(buffer.position() + entryLength);
            String[] pathSegments = SortKey.genSortKeyPathElements(path);
            this.sortBuffer.add(new SortKey(pathSegments, positionInBuffer));
        }
        this.timeCreatingSortArrayMillis += startTime.elapsed().toMillis();
        LOG.info("Built sort array in {}. Entries: {}, Total size of path strings: {}", new Object[]{startTime, this.sortBuffer.size(), IOUtils.humanReadableByteCountBin((long)totalPathSize)});
    }

    private void sortAndSaveBatch(NodeStateEntryBatch nseb) throws Exception {
        ByteBuffer buffer = nseb.getBuffer();
        LOG.info("Going to sort batch in memory. Entries: {}, Size: {}", (Object)nseb.numberOfEntries(), (Object)IOUtils.humanReadableByteCountBin((long)nseb.sizeOfEntriesBytes()));
        this.sortBuffer.clear();
        this.buildSortArray(nseb);
        if (this.sortBuffer.isEmpty()) {
            return;
        }
        Stopwatch sortClock = Stopwatch.createStarted();
        this.sortBuffer.sort(this.pathComparator);
        this.timeSortingMillis += sortClock.elapsed().toMillis();
        LOG.info("Sorted batch in {}. Saving to disk", (Object)sortClock);
        Stopwatch saveClock = Stopwatch.createStarted();
        Path newtmpfile = Files.createTempFile(this.sortWorkDir, "sortInBatch", "flatfile", new FileAttribute[0]);
        long textSize = 0L;
        ++this.batchesProcessed;
        try (OutputStream os = IndexStoreUtils.createOutputStream(newtmpfile, this.algorithm);){
            for (SortKey entry : this.sortBuffer) {
                ++this.entriesProcessed;
                int posInBuffer = entry.getBufferPos();
                buffer.position(posInBuffer);
                int pathSize = buffer.getInt();
                this.copyField(os, buffer, pathSize);
                os.write(124);
                int jsonSize = buffer.getInt();
                this.copyField(os, buffer, jsonSize);
                os.write(10);
                textSize += (long)(pathSize + jsonSize + 2);
            }
        }
        this.timeWritingMillis += saveClock.elapsed().toMillis();
        long compressedSize = Files.size(newtmpfile);
        LOG.info("Wrote batch of size {} (uncompressed {}) with {} entries in {} at {}", new Object[]{IOUtils.humanReadableByteCountBin((long)compressedSize), IOUtils.humanReadableByteCountBin((long)textSize), this.sortBuffer.size(), saveClock, PipelinedUtils.formatAsTransferSpeedMBs(compressedSize, saveClock.elapsed().toMillis())});
        this.sortBuffer.clear();
        this.sortedFilesQueue.put(newtmpfile);
    }

    private void copyField(OutputStream writer, ByteBuffer buffer, int fieldSize) throws IOException {
        writer.write(buffer.array(), buffer.position(), fieldSize);
        buffer.position(buffer.position() + fieldSize);
    }

    private static Path createdSortWorkDir(Path storeDir) throws IOException {
        Path sortedFileDir = storeDir.resolve("sort-work-dir");
        FileUtils.forceMkdir((File)sortedFileDir.toFile());
        return sortedFileDir;
    }

    public static class Result {
        private final long totalEntries;

        public Result(long totalEntries) {
            this.totalEntries = totalEntries;
        }

        public long getTotalEntries() {
            return this.totalEntries;
        }
    }
}

