/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile.pipelined;

import java.util.Locale;

public class PipelinedUtils {
    public static String formatAsPercentage(long numerator, long denominator) {
        if (denominator == 0L) {
            return "N/A";
        }
        return String.format(Locale.ROOT, "%1.2f", 100.0 * (double)numerator / (double)denominator);
    }

    public static int toPercentage(long numerator, long denominator) {
        if (denominator == 0L) {
            return -1;
        }
        return (int)Math.round(100.0 * (double)numerator / (double)denominator);
    }

    public static String formatAsTransferSpeedMBs(long numberOfBytes, long timeMillis) {
        if (timeMillis == 0L) {
            return "N/A";
        }
        double speed = 1000.0 * ((double)numberOfBytes / (double)timeMillis) / 1048576.0;
        return String.format(Locale.ROOT, "%1.2f MB/s", speed);
    }
}

