/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile.pipelined;

import java.util.Set;
import org.apache.jackrabbit.oak.commons.PathUtils;

public final class SortKey {
    private static final Set<String> COMMON_PATH_WORDS = Set.of(":index", "assets", "audit", "components", "content", "dam", "data", "items", "jcr:content", "jcr:created", "jcr:primaryType", "jcr:system", "jcr:uuid", "jcr:versionStorage", "libs", "master", "metadata", "oak:index", "predictedTags", "product-assets", "related", "renditions", "uuid", "var");
    private final String[] pathElements;
    private final int bufferPos;

    public static String[] genSortKeyPathElements(String path) {
        String[] pathElements = new String[PathUtils.getDepth((String)path)];
        int i = 0;
        for (String part : PathUtils.elements((String)path)) {
            pathElements[i] = i < 3 || part.length() == 1 || COMMON_PATH_WORDS.contains(part) ? part.intern() : part;
            ++i;
        }
        return pathElements;
    }

    public SortKey(String[] pathElements, int bufferPos) {
        this.pathElements = pathElements;
        this.bufferPos = bufferPos;
    }

    public int getBufferPos() {
        return this.bufferPos;
    }

    public String[] getPathElements() {
        return this.pathElements;
    }
}

