/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.flatfile.pipelined;

import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.pipelined.BoundedHistogram;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.pipelined.PipelinedUtils;
import org.apache.jackrabbit.oak.plugins.index.MetricsFormatter;
import org.apache.jackrabbit.oak.plugins.index.MetricsUtils;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformStageStatistics {
    public static final Logger LOG = LoggerFactory.getLogger(TransformStageStatistics.class);
    private static final int MAX_HISTOGRAM_SIZE = 1000;
    private final LongAdder mongoDocumentsTraversed = new LongAdder();
    private final LongAdder documentsRejectedSplit = new LongAdder();
    private final LongAdder documentsRejectedEmptyNodeState = new LongAdder();
    private final LongAdder entriesAccepted = new LongAdder();
    private final LongAdder entriesRejected = new LongAdder();
    private final LongAdder entriesRejectedHiddenPaths = new LongAdder();
    private final LongAdder entriesRejectedPathFiltered = new LongAdder();
    private final LongAdder entriesAcceptedTotalSize = new LongAdder();
    private final BoundedHistogram hiddenPathsRejectedHistogram = new BoundedHistogram("Hidden paths", 1000);
    private final BoundedHistogram filteredPathsRejectedHistogram = new BoundedHistogram("Filtered paths", 1000);
    private final BoundedHistogram splitDocumentsHistogram = new BoundedHistogram("Split documents", 1000);
    private final BoundedHistogram emptyNodeStateHistogram = new BoundedHistogram("Empty node state", 1000);

    public long getMongoDocumentsTraversed() {
        return this.mongoDocumentsTraversed.sum();
    }

    public long getEntriesAccepted() {
        return this.entriesAccepted.sum();
    }

    public long getEntriesRejected() {
        return this.entriesRejected.sum();
    }

    public long getDocumentsRejectedSplit() {
        return this.documentsRejectedSplit.sum();
    }

    public BoundedHistogram getHiddenPathsRejectedHistogram() {
        return this.hiddenPathsRejectedHistogram;
    }

    public BoundedHistogram getFilteredPathsRejectedHistogram() {
        return this.filteredPathsRejectedHistogram;
    }

    public BoundedHistogram getSplitDocumentsHistogram() {
        return this.splitDocumentsHistogram;
    }

    public BoundedHistogram getEmptyNodeStateHistogram() {
        return this.emptyNodeStateHistogram;
    }

    public void incrementMongoDocumentsTraversed() {
        this.mongoDocumentsTraversed.increment();
    }

    public void incrementEntriesAccepted() {
        this.entriesAccepted.increment();
    }

    public void incrementSplitDocuments() {
        this.documentsRejectedSplit.increment();
    }

    public void incrementTotalExtractedEntriesSize(int entrySize) {
        this.entriesAcceptedTotalSize.add(entrySize);
    }

    public void incrementEntriesRejected() {
        this.entriesRejected.increment();
    }

    public void addSplitDocument(String mongoDocId) {
        this.documentsRejectedSplit.increment();
        String key = TransformStageStatistics.getPathPrefix(mongoDocId, 4);
        this.splitDocumentsHistogram.addEntry(key);
    }

    public void addEmptyNodeStateEntry(String mongoDocId) {
        this.documentsRejectedEmptyNodeState.increment();
        String key = TransformStageStatistics.getPathPrefix(mongoDocId, 4);
        this.emptyNodeStateHistogram.addEntry(key);
    }

    public void addRejectedHiddenPath(String path) {
        this.entriesRejectedHiddenPaths.increment();
        String key = TransformStageStatistics.getPathPrefix(path, 3);
        this.hiddenPathsRejectedHistogram.addEntry(key);
    }

    public void addRejectedFilteredPath(String path) {
        this.entriesRejectedPathFiltered.increment();
        String key = TransformStageStatistics.getPathPrefix(path, 3);
        this.filteredPathsRejectedHistogram.addEntry(key);
    }

    public String toString() {
        return "TransformStageStatistics{mongoDocumentsProcessed=" + this.mongoDocumentsTraversed + ", splitDocumentsRejected=" + this.documentsRejectedSplit + ", emptyNodeStateDocuments=" + this.documentsRejectedEmptyNodeState + ", entriesAccepted=" + this.entriesAccepted + ", entriesRejected=" + this.entriesRejected + ", entriesRejectedHiddenPaths=" + this.entriesRejectedHiddenPaths + ", entriesRejectedPathFiltered=" + this.entriesRejectedPathFiltered + ", extractedEntriesTotalSize=" + this.entriesAcceptedTotalSize + "}";
    }

    public void publishStatistics(StatisticsProvider statisticsProvider) {
        LOG.info("Publishing transform stage statistics");
        long mongoDocumentsTraversedSum = this.mongoDocumentsTraversed.sum();
        long documentsRejectedSplitSum = this.documentsRejectedSplit.sum();
        long documentsRejectedEmptyNodeStateSum = this.documentsRejectedEmptyNodeState.sum();
        long documentsRejectedTotal = documentsRejectedSplitSum + documentsRejectedEmptyNodeStateSum;
        long documentsAcceptedTotal = mongoDocumentsTraversedSum - documentsRejectedTotal;
        long entriesAcceptedSum = this.entriesAccepted.sum();
        long entriesAcceptedTotalSizeSum = this.entriesAcceptedTotalSize.sum();
        long entriesRejectedSum = this.entriesRejected.sum();
        long entriesTraversed = entriesAcceptedSum + entriesRejectedSum;
        MetricsUtils.setCounterOnce((StatisticsProvider)statisticsProvider, (String)"oak_indexer_pipelined_documentsTraversed", (long)mongoDocumentsTraversedSum);
        MetricsUtils.setCounterOnce((StatisticsProvider)statisticsProvider, (String)"oak_indexer_pipelined_documentsRejectedSplit", (long)documentsRejectedSplitSum);
        MetricsUtils.setCounterOnce((StatisticsProvider)statisticsProvider, (String)"oak_indexer_pipelined_documentsRejectedEmptyNodeState", (long)documentsRejectedEmptyNodeStateSum);
        MetricsUtils.setCounterOnce((StatisticsProvider)statisticsProvider, (String)"oak_indexer_pipelined_documentsAccepted", (long)documentsAcceptedTotal);
        MetricsUtils.setCounterOnce((StatisticsProvider)statisticsProvider, (String)"oak_indexer_pipelined_documentsRejected", (long)documentsRejectedTotal);
        MetricsUtils.setCounterOnce((StatisticsProvider)statisticsProvider, (String)"oak_indexer_pipelined_entriesTraversed", (long)entriesTraversed);
        MetricsUtils.setCounterOnce((StatisticsProvider)statisticsProvider, (String)"oak_indexer_pipelined_entriesAccepted", (long)entriesAcceptedSum);
        MetricsUtils.setCounterOnce((StatisticsProvider)statisticsProvider, (String)"oak_indexer_pipelined_entriesRejected", (long)entriesRejectedSum);
        MetricsUtils.setCounterOnce((StatisticsProvider)statisticsProvider, (String)"oak_indexer_pipelined_entriesRejectedHiddenPaths", (long)this.entriesRejectedHiddenPaths.sum());
        MetricsUtils.setCounterOnce((StatisticsProvider)statisticsProvider, (String)"oak_indexer_pipelined_entriesRejectedPathFiltered", (long)this.entriesRejectedPathFiltered.sum());
        MetricsUtils.setCounterOnce((StatisticsProvider)statisticsProvider, (String)"oak_indexer_pipelined_extractedEntriesTotalSize", (long)entriesAcceptedTotalSizeSum);
    }

    public String formatStats() {
        long mongoDocumentsTraversedSum = this.mongoDocumentsTraversed.sum();
        long entriesAcceptedSum = this.entriesAccepted.sum();
        long extractedEntriesTotalSizeSum = this.entriesAcceptedTotalSize.sum();
        long entriesRejectedSum = this.entriesRejected.sum();
        long documentsRejectedSplitSum = this.documentsRejectedSplit.sum();
        long documentsRejectedEmptyNodeStateSum = this.documentsRejectedEmptyNodeState.sum();
        long documentsRejectedTotal = documentsRejectedSplitSum + documentsRejectedEmptyNodeStateSum;
        long documentsAcceptedTotal = mongoDocumentsTraversedSum - documentsRejectedTotal;
        long totalEntries = entriesAcceptedSum + entriesRejectedSum;
        String documentsAcceptedPercentage = PipelinedUtils.formatAsPercentage(documentsAcceptedTotal, mongoDocumentsTraversedSum);
        String entriesAcceptedPercentage = PipelinedUtils.formatAsPercentage(entriesAcceptedSum, totalEntries);
        long avgEntrySize = entriesAcceptedSum == 0L ? -1L : extractedEntriesTotalSizeSum / entriesAcceptedSum;
        return MetricsFormatter.newBuilder().add("documentsTraversed", mongoDocumentsTraversedSum).add("documentsAccepted", documentsAcceptedTotal).add("documentsRejected", documentsRejectedTotal).add("documentsAcceptedPercentage", documentsAcceptedPercentage).add("documentsRejectedSplit", documentsRejectedSplitSum).add("documentsRejectedEmptyNodeState", documentsRejectedEmptyNodeStateSum).add("entriesTraversed", totalEntries).add("entriesAccepted", entriesAcceptedSum).add("entriesRejected", entriesRejectedSum).add("entriesAcceptedPercentage", entriesAcceptedPercentage).add("entriesRejectedHiddenPaths", this.entriesRejectedHiddenPaths.sum()).add("entriesRejectedPathFiltered", this.entriesRejectedPathFiltered.sum()).add("extractedEntriesTotalSize", extractedEntriesTotalSizeSum).add("avgEntrySize", avgEntrySize).build();
    }

    private static String getPathPrefix(String path, int depth) {
        int idx = StringUtils.ordinalIndexOf((CharSequence)path, (CharSequence)"/", (int)(depth + 1));
        if (idx == -1) {
            return path;
        }
        return path.substring(0, idx);
    }
}

