/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.incrementalstore;

import com.google.common.base.StandardSystemProperty;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.function.Predicate;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.index.indexer.document.incrementalstore.IncrementalFlatFileStoreNodeStateEntryWriter;
import org.apache.jackrabbit.oak.index.indexer.document.incrementalstore.IncrementalFlatFileStoreStrategy;
import org.apache.jackrabbit.oak.index.indexer.document.incrementalstore.IncrementalStoreOperand;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalFlatFileStoreEditor
implements Editor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final BufferedWriter bufferedWriter;
    private final IncrementalFlatFileStoreNodeStateEntryWriter entryWriter;
    private final Predicate<String> predicate;
    private final IncrementalFlatFileStoreStrategy incrementalFlatFileStoreStrategy;
    private static final int LINE_SEP_LENGTH = StandardSystemProperty.LINE_SEPARATOR.value().length();

    public IncrementalFlatFileStoreEditor(BufferedWriter bufferedWriter, IncrementalFlatFileStoreNodeStateEntryWriter entryWriter, Predicate<String> predicate, IncrementalFlatFileStoreStrategy incrementalFlatFileStoreStrategy) {
        this.bufferedWriter = bufferedWriter;
        this.entryWriter = entryWriter;
        this.predicate = predicate;
        this.incrementalFlatFileStoreStrategy = incrementalFlatFileStoreStrategy;
    }

    public void enter(NodeState before, NodeState after) {
    }

    public void leave(NodeState before, NodeState after) {
    }

    public void propertyAdded(PropertyState after) {
    }

    public void propertyChanged(PropertyState before, PropertyState after) {
    }

    public void propertyDeleted(PropertyState before) {
    }

    @Nullable
    public Editor childNodeAdded(String name, NodeState after) {
        this.writeToFile(after, IncrementalStoreOperand.ADD);
        return this;
    }

    @Nullable
    public Editor childNodeChanged(String name, NodeState before, NodeState after) {
        this.writeToFile(after, IncrementalStoreOperand.MODIFY);
        return this;
    }

    @Nullable
    public Editor childNodeDeleted(String name, NodeState before) {
        this.writeToFile(before, IncrementalStoreOperand.DELETE);
        return this;
    }

    private String getPath(NodeState e) {
        if (!(e instanceof DocumentNodeState)) {
            this.log.error("DeltaFFSEditor implementation is only for DocumentNodeState");
            throw new RuntimeException("DeltaFFSEditor implementation is only for DocumentNodeState");
        }
        String path = ((DocumentNodeState)e).getPath().toString();
        return path;
    }

    private void writeToFile(NodeState e, IncrementalStoreOperand action) {
        try {
            String path = this.getPath(e);
            if (!NodeStateUtils.isHiddenPath((String)path) && this.predicate.test(path)) {
                String line = path + "|" + this.entryWriter.asJson(e) + "|" + this.incrementalFlatFileStoreStrategy.getAfterCheckpoint() + "|" + action;
                this.bufferedWriter.append(line);
                this.bufferedWriter.newLine();
                this.incrementalFlatFileStoreStrategy.incrementEntryCount();
                this.incrementalFlatFileStoreStrategy.setTextSize(this.incrementalFlatFileStoreStrategy.getTextSize() + (long)line.length() + (long)LINE_SEP_LENGTH);
            }
        }
        catch (IOException ex) {
            this.log.error("Error while creating incremental store", (Throwable)ex);
            throw new RuntimeException("Error while creating incremental store", ex);
        }
    }
}

