/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.incrementalstore;

import com.google.common.base.Stopwatch;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.commons.Compression;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.FlatFileStoreUtils;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateEntrySorter;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.PathElementComparator;
import org.apache.jackrabbit.oak.index.indexer.document.incrementalstore.IncrementalFlatFileStoreEditor;
import org.apache.jackrabbit.oak.index.indexer.document.incrementalstore.IncrementalFlatFileStoreNodeStateEntryWriter;
import org.apache.jackrabbit.oak.index.indexer.document.incrementalstore.IncrementalIndexStoreMetadata;
import org.apache.jackrabbit.oak.index.indexer.document.incrementalstore.IncrementalIndexStoreSortStrategy;
import org.apache.jackrabbit.oak.index.indexer.document.indexstore.IndexStoreMetadataOperatorImpl;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.VisibleEditor;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalFlatFileStoreStrategy
implements IncrementalIndexStoreSortStrategy {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String STORE_TYPE = "IncrementalFlatFileStore";
    public static final String OAK_INDEXER_DELETE_ORIGINAL = "oak.indexer.deleteOriginal";
    private final String beforeCheckpoint;
    private final String afterCheckpoint;
    private final PathElementComparator comparator;
    private final IncrementalFlatFileStoreNodeStateEntryWriter entryWriter;
    private final File storeDir;
    private final NodeStore nodeStore;
    private final Compression algorithm;
    private final Predicate<String> pathPredicate;
    private final boolean deleteOriginal = Boolean.parseBoolean(System.getProperty("oak.indexer.deleteOriginal", "true"));
    private final int maxMemory = Integer.getInteger("oak.indexer.maxSortMemoryInGB", 2);
    private long textSize = 0L;
    private long entryCount = 0L;
    private final Set<String> preferredPathElements;

    public IncrementalFlatFileStoreStrategy(NodeStore nodeStore, @NotNull String beforeCheckpoint, @NotNull String afterCheckpoint, File storeDir, Set<String> preferredPathElements, @NotNull Compression algorithm, Predicate<String> pathPredicate, IncrementalFlatFileStoreNodeStateEntryWriter entryWriter) {
        this.nodeStore = nodeStore;
        this.beforeCheckpoint = beforeCheckpoint;
        this.afterCheckpoint = afterCheckpoint;
        this.storeDir = storeDir;
        this.algorithm = algorithm;
        this.pathPredicate = pathPredicate;
        this.entryWriter = entryWriter;
        this.preferredPathElements = preferredPathElements;
        this.comparator = new PathElementComparator(preferredPathElements);
    }

    @Override
    public File createSortedStoreFile() throws IOException {
        Stopwatch sw = Stopwatch.createStarted();
        File file = new File(this.storeDir, FlatFileStoreUtils.getSortedStoreFileName(this.algorithm));
        try (BufferedWriter w = FlatFileStoreUtils.createWriter(file, this.algorithm);){
            NodeState before = Objects.requireNonNull(this.nodeStore.retrieve(this.beforeCheckpoint));
            NodeState after = Objects.requireNonNull(this.nodeStore.retrieve(this.afterCheckpoint));
            CommitFailedException e = EditorDiff.process((Editor)VisibleEditor.wrap((Editor)new IncrementalFlatFileStoreEditor(w, this.entryWriter, this.pathPredicate, this)), (NodeState)before, (NodeState)after);
            if (e != null) {
                this.log.error("Exception while building incremental store for checkpoint before {}, after {}", new Object[]{this.beforeCheckpoint, this.afterCheckpoint, e});
                throw new RuntimeException(e);
            }
        }
        String sizeStr = this.algorithm.equals(Compression.NONE) ? "" : String.format("compressed/%s actual size", IOUtils.humanReadableByteCount((long)this.textSize));
        this.log.info("Dumped {} nodestates in json format in {} ({} {})", new Object[]{this.entryCount, sw, IOUtils.humanReadableByteCount((long)file.length()), sizeStr});
        return this.sortStoreFile(file);
    }

    @Override
    public File createMetadataFile() throws IOException {
        IncrementalIndexStoreMetadata indexStoreMetadata = new IncrementalIndexStoreMetadata(this.beforeCheckpoint, this.afterCheckpoint, this.getStoreType(), this.getStrategyName(), this.getPreferredPaths());
        File metadataFile = new IndexStoreMetadataOperatorImpl<IncrementalIndexStoreMetadata>().createMetadataFile(indexStoreMetadata, this.storeDir, this.algorithm);
        this.log.info("Created metadataFile:{} with strategy:{} ", (Object)metadataFile.getPath(), (Object)indexStoreMetadata.getStoreType());
        return metadataFile;
    }

    @Override
    public String getStrategyName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getStoreType() {
        return STORE_TYPE;
    }

    @Override
    public String getBeforeCheckpoint() {
        return this.beforeCheckpoint;
    }

    @Override
    public String getAfterCheckpoint() {
        return this.afterCheckpoint;
    }

    @Override
    public Set<String> getPreferredPaths() {
        return this.preferredPathElements;
    }

    @Override
    public Predicate<String> getPathPredicate() {
        return this.pathPredicate;
    }

    @Override
    public long getEntryCount() {
        return this.entryCount;
    }

    public void incrementEntryCount() {
        ++this.entryCount;
    }

    public void setTextSize(long textSize) {
        this.textSize = textSize;
    }

    public long getTextSize() {
        return this.textSize;
    }

    private File sortStoreFile(File storeFile) throws IOException {
        File sortWorkDir = new File(storeFile.getParent(), "sort-work-dir");
        FileUtils.forceMkdir((File)sortWorkDir);
        File sortedFile = new File(storeFile.getParentFile(), FlatFileStoreUtils.getSortedStoreFileName(this.algorithm));
        NodeStateEntrySorter sorter = new NodeStateEntrySorter(this.comparator, storeFile, sortWorkDir, sortedFile);
        this.logFlags();
        sorter.setCompressionAlgorithm(this.algorithm);
        sorter.setMaxMemoryInGB(this.maxMemory);
        sorter.setDeleteOriginal(this.deleteOriginal);
        sorter.setActualFileSize(this.textSize);
        sorter.sort();
        return sorter.getSortedFile();
    }

    private void logFlags() {
        this.log.info("Delete original dump from traversal : {} ({})", (Object)this.deleteOriginal, (Object)OAK_INDEXER_DELETE_ORIGINAL);
        this.log.info("Max heap memory (GB) to be used for merge sort : {} ({})", (Object)this.maxMemory, (Object)"oak.indexer.maxSortMemoryInGB");
    }
}

