/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.incrementalstore;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.oak.commons.Compression;
import org.apache.jackrabbit.oak.index.IndexHelper;
import org.apache.jackrabbit.oak.index.indexer.document.CompositeException;
import org.apache.jackrabbit.oak.index.indexer.document.incrementalstore.IncrementalFlatFileStore;
import org.apache.jackrabbit.oak.index.indexer.document.incrementalstore.IncrementalFlatFileStoreNodeStateEntryReader;
import org.apache.jackrabbit.oak.index.indexer.document.incrementalstore.IncrementalFlatFileStoreNodeStateEntryWriter;
import org.apache.jackrabbit.oak.index.indexer.document.incrementalstore.IncrementalFlatFileStoreStrategy;
import org.apache.jackrabbit.oak.index.indexer.document.indexstore.IndexStore;
import org.apache.jackrabbit.oak.index.indexer.document.indexstore.IndexStoreUtils;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalStoreBuilder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String INCREMENTAL_STORE_DIR_NAME_PREFIX = "inc-store";
    private final File workDir;
    private final IndexHelper indexHelper;
    private final String initialCheckpoint;
    private final String finalCheckpoint;
    private Predicate<String> pathPredicate = path -> true;
    private Set<String> preferredPathElements = Collections.emptySet();
    private BlobStore blobStore;
    private final Compression algorithm = IndexStoreUtils.compressionAlgorithm();
    public static final String INCREMENTAL_SORT_STRATEGY_TYPE = "oak.indexer.incrementalSortStrategyType";
    private final String sortStrategyTypeString = System.getProperty("oak.indexer.incrementalSortStrategyType");
    private IncrementalSortStrategyType sortStrategyType = this.sortStrategyTypeString != null ? IncrementalSortStrategyType.valueOf(this.sortStrategyTypeString) : IncrementalSortStrategyType.INCREMENTAL_FFS_STORE;

    public IncrementalStoreBuilder(File workDir, IndexHelper indexHelper, @NotNull String initialCheckpoint, @NotNull String finalCheckpoint) {
        this.workDir = workDir;
        this.indexHelper = indexHelper;
        this.initialCheckpoint = Objects.requireNonNull(initialCheckpoint);
        this.finalCheckpoint = Objects.requireNonNull(finalCheckpoint);
    }

    public IncrementalStoreBuilder withPreferredPathElements(Set<String> preferredPathElements) {
        this.preferredPathElements = preferredPathElements;
        return this;
    }

    public IncrementalStoreBuilder withSortStrategyType(IncrementalSortStrategyType sortStrategyType) {
        this.sortStrategyType = sortStrategyType;
        return this;
    }

    public IncrementalStoreBuilder withPathPredicate(Predicate<String> pathPredicate) {
        this.pathPredicate = pathPredicate;
        return this;
    }

    public IncrementalStoreBuilder withBlobStore(BlobStore blobStore) {
        this.blobStore = blobStore;
        return this;
    }

    public IndexStore build() throws IOException, CompositeException {
        this.logFlags();
        File dir = this.createStoreDir();
        if (Objects.requireNonNull(this.sortStrategyType) == IncrementalSortStrategyType.INCREMENTAL_FFS_STORE) {
            IncrementalFlatFileStoreNodeStateEntryWriter entryWriter = new IncrementalFlatFileStoreNodeStateEntryWriter(this.blobStore);
            IncrementalFlatFileStoreStrategy strategy = new IncrementalFlatFileStoreStrategy(this.indexHelper.getNodeStore(), this.initialCheckpoint, this.finalCheckpoint, dir, this.preferredPathElements, this.algorithm, this.pathPredicate, entryWriter);
            File metadataFile = strategy.createMetadataFile();
            File incrementalStoreFile = strategy.createSortedStoreFile();
            long entryCount = strategy.getEntryCount();
            IncrementalFlatFileStore store = new IncrementalFlatFileStore(this.blobStore, incrementalStoreFile, metadataFile, new IncrementalFlatFileStoreNodeStateEntryReader(this.blobStore), Collections.unmodifiableSet(this.preferredPathElements), this.algorithm);
            if (entryCount > 0L) {
                store.setEntryCount(entryCount);
            }
            return store;
        }
        throw new IllegalStateException("Not a valid sort strategy value " + this.sortStrategyType);
    }

    private File createStoreDir() throws IOException {
        return Files.createTempDirectory(this.workDir.toPath(), this.getDirNamePrefix(), new FileAttribute[0]).toFile();
    }

    private String getDirNamePrefix() {
        return INCREMENTAL_STORE_DIR_NAME_PREFIX + this.sortStrategyType;
    }

    private void logFlags() {
        this.log.info("Preferred path elements are {}", (Object)Iterables.toString(this.preferredPathElements));
        this.log.info("Compression enabled while sorting : {} ({})", (Object)IndexStoreUtils.compressionEnabled(), (Object)"oak.indexer.useZip");
        this.log.info("LZ4 enabled for compression algorithm : {} ({})", (Object)IndexStoreUtils.useLZ4(), (Object)"oak.indexer.useLZ4");
    }

    public static enum IncrementalSortStrategyType {
        INCREMENTAL_FFS_STORE;

    }
}

