/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.incrementalstore;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.commons.Compression;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.NodeStateHolder;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.PathElementComparator;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.SimpleNodeStateHolder;
import org.apache.jackrabbit.oak.index.indexer.document.incrementalstore.IncrementalFlatFileStoreNodeStateEntryWriter;
import org.apache.jackrabbit.oak.index.indexer.document.incrementalstore.IncrementalIndexStoreMetadata;
import org.apache.jackrabbit.oak.index.indexer.document.incrementalstore.IncrementalStoreOperand;
import org.apache.jackrabbit.oak.index.indexer.document.incrementalstore.MergeIncrementalStore;
import org.apache.jackrabbit.oak.index.indexer.document.indexstore.IndexStoreMetadata;
import org.apache.jackrabbit.oak.index.indexer.document.indexstore.IndexStoreMetadataOperatorImpl;
import org.apache.jackrabbit.oak.index.indexer.document.indexstore.IndexStoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeIncrementalFlatFileStore
implements MergeIncrementalStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String MERGE_BASE_AND_INCREMENTAL_FLAT_FILE_STORE = "MergeBaseAndIncrementalFlatFileStore";
    private final File baseFFS;
    private final File incrementalFFS;
    private final File merged;
    private final Compression algorithm;
    private final Comparator<NodeStateHolder> comparator;
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    public MergeIncrementalFlatFileStore(Set<String> preferredPathElements, File baseFFS, File incrementalFFS, File merged, Compression algorithm) throws IOException {
        this.baseFFS = baseFFS;
        this.incrementalFFS = incrementalFFS;
        this.merged = merged;
        this.algorithm = algorithm;
        this.comparator = (e1, e2) -> new PathElementComparator(preferredPathElements).compare((Iterable<String>)e1.getPathElements(), (Iterable<String>)e2.getPathElements());
        if (merged.exists()) {
            this.log.warn("merged file:{} exists, this file will be replaced with new mergedFFS file", (Object)merged.getAbsolutePath());
        } else {
            Files.createDirectories(merged.getParentFile().toPath(), new FileAttribute[0]);
        }
        IndexStoreUtils.validateFlatFileStoreFileName(merged, algorithm);
        this.basicFileValidation(algorithm, baseFFS, incrementalFFS);
    }

    @Override
    public void doMerge() throws IOException {
        this.log.info("base FFS " + this.baseFFS.getAbsolutePath());
        this.log.info("incremental FFS " + this.incrementalFFS.getAbsolutePath());
        this.log.info("merged FFS " + this.merged.getAbsolutePath());
        this.mergeMetadataFiles();
        this.mergeIndexStoreFiles();
    }

    @Override
    public String getStrategyName() {
        return MERGE_BASE_AND_INCREMENTAL_FLAT_FILE_STORE;
    }

    private void basicFileValidation(Compression algorithm, File ... files) {
        for (File file : files) {
            Preconditions.checkState((boolean)file.isFile(), (String)"File doesn't exist {}", (Object)file.getAbsolutePath());
            IndexStoreUtils.validateFlatFileStoreFileName(file, algorithm);
            Preconditions.checkState((boolean)IndexStoreUtils.getMetadataFile(file, algorithm).exists(), (String)"metadata file is not present in same directory as indexStore. indexStoreFile:{}, metadataFile should be available at:{}", (Object)file.getAbsolutePath(), (Object)IndexStoreUtils.getMetadataFile(file, algorithm));
        }
    }

    private void mergeIndexStoreFiles() throws IOException {
        Map<String, IncrementalStoreOperand> enumMap = Arrays.stream(IncrementalStoreOperand.values()).collect(Collectors.toUnmodifiableMap(IncrementalStoreOperand::toString, k -> IncrementalStoreOperand.valueOf(k.name())));
        try (BufferedWriter writer = IndexStoreUtils.createWriter(this.merged, this.algorithm);
             BufferedReader baseFFSBufferedReader = IndexStoreUtils.createReader(this.baseFFS, this.algorithm);
             BufferedReader incrementalFFSBufferedReader = IndexStoreUtils.createReader(this.incrementalFFS, this.algorithm);){
            String baseFFSLine = baseFFSBufferedReader.readLine();
            String incrementalFFSLine = incrementalFFSBufferedReader.readLine();
            while (baseFFSLine != null || incrementalFFSLine != null) {
                if (baseFFSLine != null && incrementalFFSLine != null) {
                    int compared = this.comparator.compare(new SimpleNodeStateHolder(baseFFSLine), new SimpleNodeStateHolder(incrementalFFSLine));
                    if (compared < 0) {
                        baseFFSLine = this.writeAndAdvance(writer, baseFFSBufferedReader, baseFFSLine);
                        continue;
                    }
                    if (compared > 0) {
                        incrementalFFSLine = this.processIncrementalFFSLine(enumMap, writer, incrementalFFSBufferedReader, incrementalFFSLine);
                        continue;
                    }
                    String[] incrementalFFSParts = IncrementalFlatFileStoreNodeStateEntryWriter.getParts(incrementalFFSLine);
                    String operand = this.getOperand(incrementalFFSParts);
                    switch (enumMap.get(operand)) {
                        case ADD: {
                            this.log.warn("Expected operand {} or {} but got {} for incremental line {}. Merging will proceed, but this is unexpected.", new Object[]{IncrementalStoreOperand.MODIFY, IncrementalStoreOperand.DELETE, this.getOperand(incrementalFFSParts), incrementalFFSLine});
                            incrementalFFSLine = this.writeAndAdvance(writer, incrementalFFSBufferedReader, this.getFFSLineFromIncrementalFFSParts(incrementalFFSParts));
                            break;
                        }
                        case MODIFY: {
                            incrementalFFSLine = this.writeAndAdvance(writer, incrementalFFSBufferedReader, this.getFFSLineFromIncrementalFFSParts(incrementalFFSParts));
                            break;
                        }
                        case DELETE: {
                            incrementalFFSLine = incrementalFFSBufferedReader.readLine();
                            break;
                        }
                        default: {
                            this.log.error("wrong operand in incremental ffs: operand:{}, line:{}", (Object)operand, (Object)incrementalFFSLine);
                            throw new RuntimeException("wrong operand in incremental ffs: operand:" + operand + ", line:" + incrementalFFSLine);
                        }
                    }
                    baseFFSLine = baseFFSBufferedReader.readLine();
                    continue;
                }
                if (incrementalFFSLine == null) {
                    baseFFSLine = this.writeRestOfFFSFileAndAdvance(writer, baseFFSBufferedReader, baseFFSLine);
                    continue;
                }
                incrementalFFSLine = this.writeRestOfIncrementalFileAndAdvance(writer, incrementalFFSBufferedReader, incrementalFFSLine);
            }
        }
    }

    private String processIncrementalFFSLine(Map<String, IncrementalStoreOperand> enumMap, BufferedWriter writer, BufferedReader incrementalFFSBufferedReader, String incrementalFFSLine) throws IOException {
        String[] incrementalFFSParts = IncrementalFlatFileStoreNodeStateEntryWriter.getParts(incrementalFFSLine);
        String operand = this.getOperand(incrementalFFSParts);
        switch (enumMap.get(operand)) {
            case ADD: {
                incrementalFFSLine = this.writeAndAdvance(writer, incrementalFFSBufferedReader, this.getFFSLineFromIncrementalFFSParts(incrementalFFSParts));
                break;
            }
            case MODIFY: {
                this.log.warn("Expected operand {} but got {} for incremental line {}. Merging will proceed, but this is unexpected.", new Object[]{IncrementalStoreOperand.ADD, operand, incrementalFFSLine});
                incrementalFFSLine = this.writeAndAdvance(writer, incrementalFFSBufferedReader, this.getFFSLineFromIncrementalFFSParts(incrementalFFSParts));
                break;
            }
            case DELETE: {
                this.log.warn("Expected operand {} but got {} for incremental line {}. Merging will proceed as usual, but this needs to be looked into.", new Object[]{IncrementalStoreOperand.ADD, operand, incrementalFFSLine});
                incrementalFFSLine = incrementalFFSBufferedReader.readLine();
                break;
            }
            default: {
                this.log.error("Wrong operand in incremental ffs: operand:{}, line:{}", (Object)operand, (Object)incrementalFFSLine);
                throw new RuntimeException("wrong operand in incremental ffs: operand:" + operand + ", line:" + incrementalFFSLine);
            }
        }
        return incrementalFFSLine;
    }

    private IndexStoreMetadata getIndexStoreMetadataForMergedFile() throws IOException {
        File baseFFSMetadataFile = IndexStoreUtils.getMetadataFile(this.baseFFS, this.algorithm);
        File incrementalMetadataFile = IndexStoreUtils.getMetadataFile(this.incrementalFFS, this.algorithm);
        if (baseFFSMetadataFile.exists() && incrementalMetadataFile.exists()) {
            IndexStoreMetadata indexStoreMetadata = new IndexStoreMetadataOperatorImpl<IndexStoreMetadata>().getIndexStoreMetadata(baseFFSMetadataFile, this.algorithm, new TypeReference<IndexStoreMetadata>(){});
            IncrementalIndexStoreMetadata incrementalIndexStoreMetadata = new IndexStoreMetadataOperatorImpl<IncrementalIndexStoreMetadata>().getIndexStoreMetadata(incrementalMetadataFile, this.algorithm, new TypeReference<IncrementalIndexStoreMetadata>(){});
            return this.mergeIndexStores(indexStoreMetadata, incrementalIndexStoreMetadata);
        }
        throw new RuntimeException("either one or both metadataFiles don't exist at path: " + baseFFSMetadataFile.getAbsolutePath() + ", " + incrementalMetadataFile.getAbsolutePath());
    }

    private void mergeMetadataFiles() throws IOException {
        try (BufferedWriter writer = IndexStoreUtils.createWriter(IndexStoreUtils.getMetadataFile(this.merged, this.algorithm), this.algorithm);){
            JSON_MAPPER.writeValue((Writer)writer, (Object)this.getIndexStoreMetadataForMergedFile());
        }
    }

    private IndexStoreMetadata mergeIndexStores(IndexStoreMetadata indexStoreMetadata, IncrementalIndexStoreMetadata incrementalIndexStoreMetadata) {
        Preconditions.checkState((boolean)indexStoreMetadata.getCheckpoint().equals(incrementalIndexStoreMetadata.getBeforeCheckpoint()));
        Preconditions.checkState((boolean)indexStoreMetadata.getPreferredPaths().equals(incrementalIndexStoreMetadata.getPreferredPaths()));
        return new IndexStoreMetadata(incrementalIndexStoreMetadata.getAfterCheckpoint(), indexStoreMetadata.getStoreType(), this.getStrategyName(), indexStoreMetadata.getPreferredPaths());
    }

    private String writeAndAdvance(BufferedWriter writer, BufferedReader bufferedReader, String stringToWriteInMergeFile) throws IOException {
        writer.write(stringToWriteInMergeFile);
        writer.write("\n");
        stringToWriteInMergeFile = bufferedReader.readLine();
        return stringToWriteInMergeFile;
    }

    private String writeRestOfFFSFileAndAdvance(BufferedWriter writer, BufferedReader bufferedReader, String baseFFSLine) throws IOException {
        while ((baseFFSLine = this.writeAndAdvance(writer, bufferedReader, baseFFSLine)) != null) {
        }
        return bufferedReader.readLine();
    }

    private String writeRestOfIncrementalFileAndAdvance(BufferedWriter writer, BufferedReader bufferedReader, String incrementalFFSLine) throws IOException {
        Map<String, IncrementalStoreOperand> enumMap = Arrays.stream(IncrementalStoreOperand.values()).collect(Collectors.toUnmodifiableMap(IncrementalStoreOperand::toString, k -> IncrementalStoreOperand.valueOf(k.name())));
        while ((incrementalFFSLine = this.processIncrementalFFSLine(enumMap, writer, bufferedReader, incrementalFFSLine)) != null) {
        }
        return bufferedReader.readLine();
    }

    private String getOperand(String[] incrementalFFSParts) {
        return incrementalFFSParts[3];
    }

    private String getFFSLineFromIncrementalFFSParts(String[] incrementalFFSParts) {
        return incrementalFFSParts[0] + "|" + incrementalFFSParts[1];
    }
}

