/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.indexstore;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.apache.jackrabbit.oak.commons.Compression;
import org.apache.jackrabbit.oak.index.indexer.document.indexstore.IndexStoreMetadataOperator;
import org.apache.jackrabbit.oak.index.indexer.document.indexstore.IndexStoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexStoreMetadataOperatorImpl<M>
implements IndexStoreMetadataOperator<M> {
    private static final Logger log = LoggerFactory.getLogger(IndexStoreMetadataOperatorImpl.class);
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    @Override
    public File createMetadataFile(M m, File file, Compression algorithm) throws IOException {
        File metadataFile = file.isDirectory() ? new File(file, IndexStoreUtils.getMetadataFileName(algorithm)) : file;
        try (BufferedWriter metadataWriter = IndexStoreUtils.createWriter(metadataFile, algorithm);){
            this.writeMetadataToFile(metadataWriter, m);
        }
        log.info("Created metadataFile:{} ", (Object)metadataFile.getPath());
        return metadataFile;
    }

    private void writeMetadataToFile(BufferedWriter bufferedWriter, M m) throws IOException {
        JSON_MAPPER.writeValue((Writer)bufferedWriter, m);
    }

    @Override
    public M getIndexStoreMetadata(File metadataFile, Compression algorithm, TypeReference<M> clazz) throws IOException {
        JavaType javaType = JSON_MAPPER.getTypeFactory().constructType(clazz);
        try (BufferedReader metadataFilebufferedReader = IndexStoreUtils.createReader(metadataFile, algorithm);){
            Object object = JSON_MAPPER.readValue(metadataFilebufferedReader.readLine(), javaType);
            return (M)object;
        }
    }
}

