/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.indexstore;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.jackrabbit.oak.commons.Compression;
import org.apache.jackrabbit.oak.index.indexer.document.indexstore.IndexStoreMetadata;
import org.apache.jackrabbit.oak.index.indexer.document.indexstore.IndexStoreMetadataOperatorImpl;
import org.apache.jackrabbit.oak.index.indexer.document.indexstore.IndexStoreSortStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IndexStoreSortStrategyBase
implements IndexStoreSortStrategy {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final File storeDir;
    private final Compression algorithm;
    private final Predicate<String> pathPredicate;
    private final Set<String> preferredPaths;
    private final String checkpoint;
    private static final String DEFAULT_INDEX_STORE_TYPE = "FlatFileStore";

    public IndexStoreSortStrategyBase(File storeDir, Compression algorithm, Predicate<String> pathPredicate, Set<String> preferredPaths, String checkpoint) {
        this.storeDir = storeDir;
        this.algorithm = algorithm;
        this.pathPredicate = pathPredicate;
        this.preferredPaths = preferredPaths;
        this.checkpoint = checkpoint;
    }

    @Override
    public File getStoreDir() {
        return this.storeDir;
    }

    @Override
    public Compression getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getStrategyName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getStoreType() {
        return DEFAULT_INDEX_STORE_TYPE;
    }

    @Override
    public String getCheckpoint() {
        return this.checkpoint;
    }

    @Override
    public Set<String> getPreferredPaths() {
        return this.preferredPaths;
    }

    @Override
    public Predicate<String> getPathPredicate() {
        return this.pathPredicate;
    }

    @Override
    public File createMetadataFile() throws IOException {
        IndexStoreMetadata indexStoreMetadata = new IndexStoreMetadata(this.checkpoint, this.getStoreType(), this.getStrategyName(), this.preferredPaths);
        File metadataFile = new IndexStoreMetadataOperatorImpl<IndexStoreMetadata>().createMetadataFile(indexStoreMetadata, this.storeDir, this.algorithm);
        this.log.info("Created metadataFile:{} with strategy:{} ", (Object)metadataFile.getPath(), (Object)this.getStoreType());
        return metadataFile;
    }
}

