/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.index.indexer.document.indexstore;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.commons.Compression;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.LZ4Compression;
import org.jetbrains.annotations.NotNull;

public class IndexStoreUtils {
    public static final String METADATA_SUFFIX = ".metadata";
    public static final String OAK_INDEXER_USE_ZIP = "oak.indexer.useZip";
    public static final String OAK_INDEXER_USE_LZ4 = "oak.indexer.useLZ4";

    public static boolean compressionEnabled() {
        return Boolean.parseBoolean(System.getProperty(OAK_INDEXER_USE_ZIP, "true"));
    }

    public static boolean useLZ4() {
        return Boolean.parseBoolean(System.getProperty(OAK_INDEXER_USE_LZ4, "true"));
    }

    public static Compression compressionAlgorithm() {
        if (!IndexStoreUtils.compressionEnabled()) {
            return Compression.NONE;
        }
        return IndexStoreUtils.useLZ4() ? new LZ4Compression() : Compression.GZIP;
    }

    public static BufferedReader createReader(File file, boolean compressionEnabled) {
        return IndexStoreUtils.createReader(file, compressionEnabled ? Compression.GZIP : Compression.NONE);
    }

    public static BufferedReader createReader(File file, Compression algorithm) {
        try {
            FileInputStream in = new FileInputStream(file);
            return new BufferedReader(new InputStreamReader(algorithm.getInputStream((InputStream)in)));
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening file " + file, e);
        }
    }

    public static BufferedWriter createWriter(File file, boolean compressionEnabled) throws IOException {
        return IndexStoreUtils.createWriter(file, compressionEnabled ? Compression.GZIP : Compression.NONE);
    }

    public static BufferedWriter createWriter(File file, Compression algorithm) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        return new BufferedWriter(new OutputStreamWriter(algorithm.getOutputStream((OutputStream)out)));
    }

    public static OutputStream createOutputStream(Path file, Compression algorithm) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0]));
        return algorithm.getOutputStream((OutputStream)out);
    }

    public static long sizeOf(List<File> sortedFiles) {
        return sortedFiles.stream().mapToLong(File::length).sum();
    }

    public static String getSortedStoreFileName(Compression algorithm) {
        return algorithm.addSuffix("store-sorted.json");
    }

    public static String getMetadataFileName(Compression algorithm) {
        return algorithm.addSuffix("store-sorted.json.metadata");
    }

    public static File getMetadataFile(File indexStoreFile, Compression algorithm) {
        File metadataFile;
        if (algorithm.equals(Compression.NONE)) {
            metadataFile = new File(indexStoreFile.getAbsolutePath() + METADATA_SUFFIX);
        } else {
            String fileName = indexStoreFile.getName();
            String compressionSuffix = IndexStoreUtils.getCompressionSuffix(indexStoreFile);
            Preconditions.checkState((boolean)algorithm.addSuffix("").equals(compressionSuffix));
            String fileNameWithoutCompressionSuffix = fileName.substring(0, fileName.lastIndexOf("."));
            metadataFile = new File(algorithm.addSuffix(indexStoreFile.getParent() + "/" + fileNameWithoutCompressionSuffix + METADATA_SUFFIX));
        }
        return metadataFile;
    }

    private static String getCompressionSuffix(File file) {
        return file.getName().substring(file.getName().lastIndexOf("."));
    }

    public static void validateFlatFileStoreFileName(File file, @NotNull Compression algorithm) {
        if (!algorithm.equals(Compression.NONE)) {
            Preconditions.checkState((boolean)algorithm.addSuffix("").equals(IndexStoreUtils.getCompressionSuffix(file)), (String)"File suffix should be in correspondence with compression algorithm. Filename:{}, Compression suffix:{} ", (Object)file.getAbsolutePath(), (Object)algorithm.addSuffix(""));
        }
    }
}

